function OUTPUT = ModelFit(DATA,est,bs)

nf = 3;
numGRP = 6;

wtmean = @(x,p) (p'*x)./sum(p);

load('Gender Gap Data.mat','measInfo');
DATAorig = load('Gender Gap Data.mat','DATA');
DATAorig = bootsamp(DATAorig.DATA,bs);
N = numel(DATAorig);
R = numel(DATA)/N;

meas = vertcat(DATAorig.meas);

pwt = repmat(vertcat(DATAorig.pwt),[R 1]);
grp = repmat(vertcat(DATAorig.grp),[R 1]);

%% Measurement fit
meas_fit = nan(2,4);
i = 1;
for m = [1 10 16 30 59]
    
    if ~ismember(measInfo(m).type,[inf 2])
        error('cannot calculate model fit of measures')
    end
    
    meas_fit(i,1) = m;
    y = repmat(meas(:,m),[R 1]);    
    if measInfo(m).type==2
        y = y - 1;
    end
    
    hasy = ~isnan(y);
    meas_fit(i,2) = wtmean(y(hasy),pwt(hasy));
    yhat = [ones(N*R,1) vertcat(DATA.theta)]*est.meascoef{m};    
    if measInfo(m).type==2
        yhat = exp(yhat)./(1+exp(yhat));
    end
    meas_fit(i,3) = wtmean(yhat(hasy),pwt(hasy));
    
    meas_fit(i,4) = meas_fit(i,2) - meas_fit(i,3); 
    i = i + 1;
end

meas_fit = [{measInfo(meas_fit(:,1)).name}' num2cell(meas_fit(:,2:end))];

%% Education Fit
num_hgc = cellfun(@(x) numel(x),{DATAorig.hgc})';
hgc_obs = nan(N,1);
hgc_obs(num_hgc>0) = cellfun(@(x) x(end),{DATAorig(num_hgc>0).hgc});
num_hgc = repmat(num_hgc,[R 1]);
hgc_obs = repmat(hgc_obs,[R 1]);

D = rmfield(DATA,{'hgc','t'});
[D(:).hgc] = deal(9);
[D(:).t] = deal(1);
D = SimulateData(D,est,max(num_hgc));

hgc_pred = nan(N*R,1);
for t = 1:max(num_hgc)
    I = num_hgc==t;
    hgc_pred(I,:) = D(t).hgc(I);
end

hgctime_fit = nan(11,2);
for t = 1:11
    I = (num_hgc==t);
    hgctime_fit(t,1) = wtmean(hgc_obs(I),pwt(I));
    hgctime_fit(t,2) = wtmean(hgc_pred(I),pwt(I));
end
hgctime_fit(:,3) = hgctime_fit(:,1) - hgctime_fit(:,2);
timefreq = tabulate(num_hgc);
hgctime_fit = [arrayfun(@(i,f) sprintf('%d years (%0.0f%% of sample)',i,f),(1:11)',timefreq(2:end,3),'unif',0) num2cell(hgctime_fit)];

hgcgrp_fit = nan(numGRP,2);
for g = 1:numGRP
    I = (grp==g) & ~isnan(hgc_obs);
    hgcgrp_fit(g,1) = wtmean(hgc_obs(I),pwt(I));
    hgcgrp_fit(g,2) = wtmean(hgc_pred(I),pwt(I));  
end
hgcgrp_fit(:,3) = hgcgrp_fit(:,1) - hgcgrp_fit(:,2);
hgcgrp_fit = [{'White Males','White Females','Black Males','Black Females','Hispanic Males','Hispanic Females'}' num2cell(hgcgrp_fit)];

hgcfreq_fit = nan(16,2);
for h = 9:16
    I = ~isnan(hgc_obs);
    hgcfreq_fit(h,1) = wtmean(hgc_obs(I)==h,pwt(I));
    hgcfreq_fit(h,2) = wtmean(hgc_pred(I)==h,pwt(I));  
end
hgcfreq_fit(:,3) = hgcfreq_fit(:,1) - hgcfreq_fit(:,2);
hgcfreq_fit = [arrayfun(@(h) ['HGC==' num2str(h)],(9:16)','unif',0) num2cell(hgcfreq_fit(9:16,:))];

%% Arrest Fit

num_arr = cellfun(@(x) numel(x),{DATAorig.Arrest})';
arr_obs = nan(N,1);
arr_obs(num_arr>0) = cellfun(@(x) max(x),{DATAorig(num_arr>0).Arrest});
num_arr = repmat(num_arr,[R 1]);
arr_obs = repmat(arr_obs,[R 1]);

D = rmfield(DATA,{'hgc','t'});
[D(:).hgc] = deal(9);
[D(:).t] = deal(1);
D = SimulateData(D,est,max(num_arr));

arr_pred = nan(N*R,1);
for t = 1:max(num_arr)
    I = num_arr==t;
    Arr = cat(2,D(1:t).Arrest);
    arr_pred(I,:) = max(Arr(I,:),[],2);
end

arrgrp_fit = nan(numGRP,2);
for g = 1:numGRP
    I = (grp==g) & ~isnan(arr_obs);
    arrgrp_fit(g,1) = wtmean(arr_obs(I),pwt(I));
    arrgrp_fit(g,2) = wtmean(arr_pred(I),pwt(I));  
end
arrgrp_fit(:,3) = arrgrp_fit(:,1) - arrgrp_fit(:,2);
arrgrp_fit = [{'White Males','White Females','Black Males','Black Females','Hispanic Males','Hispanic Females'}' num2cell(arrgrp_fit)];

%% Output
OUTPUT = struct();
OUTPUT.meas_fit = meas_fit;
OUTPUT.hgctime_fit = hgctime_fit;
OUTPUT.hgcgrp_fit = hgcgrp_fit;
OUTPUT.hgcfreq_fit = hgcfreq_fit;
OUTPUT.arrgrp_fit =arrgrp_fit;


    

