function OUTPUT = FactorSummary(factmoms)
    
numGRP = 6;
nf = 3;

sdALL = sqrt(diag(factmoms.factcovALL));
mnALL = factmoms.factmeanALL;
factmeanGRP = factmoms.factmeanGRP;
factcovGRP = factmoms.factcovGRP;
factcovALL = factmoms.factcovALL;
typeprGRP = factmoms.typeprGRP;
factmeanTYPE = factmoms.factmeanTYPE;

factmeanGRP_normed = bsxfun(@rdivide,bsxfun(@minus,factmeanGRP,mnALL),sdALL);
factmeanGRP_normed = reshape(factmeanGRP_normed,[nf 2 3]);

skillnames = {'Family','Math/Verbal','Behavior'}';

FactorMeanNorm = cat(2,factmeanGRP_normed(:,2,:),factmeanGRP_normed(:,1,:)-factmeanGRP_normed(:,2,:));
FactorMeanNorm_White = [skillnames num2cell(FactorMeanNorm(:,:,1))];
FactorMeanNorm_Black = [skillnames num2cell(FactorMeanNorm(:,:,2))];
FactorMeanNorm_Hisp = [skillnames num2cell(FactorMeanNorm(:,:,3))];

FactMOM1_All = [{'\textit{Mean}'} num2cell(mnALL');
                       {'\textit{Variance}'} num2cell(diag(factcovALL)')];
[~,C] = cov2corr(factcovALL);
C = num2cell(C);
C(triu(ones(nf),1)==1) = {'--'};
C(eye(nf)==1) = {'1'};
FactMOM2_All = [skillnames C];
Typenames = {'Type 1','Type 2','Type 3','Type 4','Type 5','Type 6','Type 7','Type 8'}';
FactMOM3_All = [Typenames num2cell(factmeanTYPE)];

factmomGRP_raw = cell(2,numGRP);
for g = 1:numGRP
    factmomGRP_raw{1,g} = [{'\textit{Mean}'} num2cell(factmeanGRP(:,g)');
                       {'\textit{Variance}'} num2cell(diag(factcovGRP(:,:,g))')];
    [~,C] = cov2corr(factcovGRP(:,:,g));
    C = num2cell(C);
    C(eye(nf)==1) = {'1'};
    C(triu(ones(nf),1)==1) = {'--'};
    C = [skillnames C];    
    factmomGRP_raw{2,g} = C;
end

TypeShare = reshape(typeprGRP,[size(typeprGRP,1) 2 3]);
TypeShare = reshape(TypeShare(:,:,[2 1 3]),[size(TypeShare,1) numGRP]);
TypeInfo = [Typenames num2cell(TypeShare)];

OUTPUT = struct();
OUTPUT.FactorMeanNorm_White = FactorMeanNorm_White;
OUTPUT.FactorMeanNorm_Black = FactorMeanNorm_Black;
OUTPUT.FactorMeanNorm_Hisp = FactorMeanNorm_Hisp;
OUTPUT.FactorMOM1_All = FactMOM1_All;
OUTPUT.FactorMOM2_All = FactMOM2_All;
OUTPUT.FactorMOM3_All = FactMOM3_All;
OUTPUT.FactorMOM1_White = cat(2,factmomGRP_raw{1,1},factmomGRP_raw{1,2}(:,2:end));
OUTPUT.FactorMOM2_White = cat(2,factmomGRP_raw{2,1},factmomGRP_raw{2,2}(:,2:end));
OUTPUT.FactorMOM1_Black = cat(2,factmomGRP_raw{1,3},factmomGRP_raw{1,4}(:,2:end));
OUTPUT.FactorMOM2_Black = cat(2,factmomGRP_raw{2,3},factmomGRP_raw{2,4}(:,2:end));
OUTPUT.FactorMOM1_Hisp = cat(2,factmomGRP_raw{1,5},factmomGRP_raw{1,6}(:,2:end));
OUTPUT.FactorMOM2_Hisp = cat(2,factmomGRP_raw{2,5},factmomGRP_raw{2,6}(:,2:end));
OUTPUT.TypeInfo = TypeInfo;
