function OUTPUT = FactorMoments(est,DATA)

N = numel(DATA);
  
[nf,K] = size(est.factmean);
        
expv = exp([zeros(N,1) vertcat(DATA.typeX)*est.typecoef]);
pr = bsxfun(@rdivide,expv,sum(expv,2));
pr = (vertcat(DATA.pwt)'*pr)./sum(vertcat(DATA.pwt));
[factmeanALL,factcovALL] = gmdmoments(est.factmean,est.factcov,pr);
            
factmeanGRP = zeros(nf,6);
factcovGRP = zeros(nf,nf,6);
typeprGRP = zeros(6,K);
for g = 1:6
    expv = exp([0 typeX(struct('grp',g))*est.typecoef]);
    typeprGRP(g,:) = expv./sum(expv);
    [factmeanGRP(:,g),factcovGRP(:,:,g)] = gmdmoments(est.factmean,est.factcov,typeprGRP(g,:));
end

OUTPUT = struct('factmeanALL',factmeanALL...
    ,'factcovALL',factcovALL...
    ,'factmeanGRP',factmeanGRP...
    ,'factcovGRP',factcovGRP...
    ,'typeprGRP',typeprGRP'...
    ,'factmeanTYPE',est.factmean');
