function OUTPUT = DynamicSelection(DATA,est,factmoms)

numGRP = 6;
T = 9;
nf = 3;

factmeanALL = factmoms.factmeanALL;
factstdALL = sqrt(diag(factmoms.factcovALL));

D = rmfield(DATA,{'hgc','t'});
[D(:).hgc] = deal(9);
[D(:).t] = deal(1);
D = SimulateData(D,est,T+1);
D = D(end);

thetaNORM = bsxfun(@rdivide,bsxfun(@minus,D.theta,factmeanALL'),factstdALL');

wtmean = @(x,p) (p'*x)./sum(p);

Y = nan(16,nf,numGRP);
for g = 1:numGRP
    for h = 9:16
        I = (D.grp==g) & (D.hgc>=h);
        Y(h,:,g) = wtmean(thetaNORM(I,:),D.pwt(I));
    end
end
Y = reshape(Y,[16 nf 2 3]);

OUTPUT = struct();
OUTPUT.Y = Y;