function OUTPUT = ArrestGap(DATA,est,factmoms)

nf = 3;
T = 9;

factmeanGRP = factmoms.factmeanGRP;

D = rmfield(DATA,{'hgc','t'});
[D(:).hgc] = deal(9);
[D(:).t] = deal(1);

calcpr = @(D) ( D(1).pwt'*max(horzcat(D.Arrest),[],2) )./sum(D(1).pwt);

baselinegap = zeros(1,7);
EqSkill = zeros(nf+1,7);

for c = 1:7
    switch c
        case 1
            gleft = 3; gright = 4;
        case 2
            gleft = 1; gright = 2;
        case 3
            gleft = 5; gright = 6;
        case 4
            gleft = 3; gright = 1;
        case 5
            gleft = 5; gright = 1;
        case 6
            gleft = 4; gright = 2;
        case 7
            gleft = 6; gright = 2;
    end
    
    Dr = D(vertcat(D.grp)==gright);
    Dl = D(vertcat(D.grp)==gleft);
    
    pr0 = calcpr(SimulateData(Dr,est,T+1));
    
    baselinegap(c) = calcpr(SimulateData(Dl,est,T+1)) - pr0;
   
    skilldiff = factmeanGRP(:,gright)-factmeanGRP(:,gleft);
    addtheta = [diag(skilldiff); skilldiff'];
    
    for f = 1:nf+1
        EqSkill(f,c) = calcpr(SimulateData(Dl,est,T+1,'theta',addtheta(f,:))) - pr0;
    end
    
end

skillnames = {'Family','Math/Verbal','Behavior'};

OUTPUT = struct();
OUTPUT.base_gap = [{'Baseline Gap'} num2cell(baselinegap)];
OUTPUT.EqSkill = [[strcat(skillnames,' Only') {'All Factors'}]' num2cell(EqSkill)];

