function OUTPUT = AmeSchLev(DATA,est,factmoms)

nf = 3;
numGRP = 6;
T = 9;

factstdALL = sqrt(diag(factmoms.factcovALL));
addtheta = diag(factstdALL);

AmeSkillGRP = zeros(nf,3,numGRP);
BasePr = zeros(1,3,numGRP);
for h = 1:3
    switch h
        case 1
            hmin = 9;
            hmax = 12;
        case 2
            hmin = 12;
            hmax = 13;
        case 3
            hmin = 13;
            hmax = 16;
    end

    calcpr = @(D) D(end).pwt'*(D(end).hgc>=hmax)./sum(D(end).pwt);
    
    th = cellfun(@(t,hgc) min(t(hgc==hmin)),{DATA.t},{DATA.hgc},'unif',0);
    hasH = ~cellfun('isempty',th);
    Dh = DATA(hasH);
    [Dh(:).t] = th{hasH};
    [Dh(:).hgc] = deal(hmin);

    for g = 1:6
        Dhg = Dh(vertcat(Dh.grp)==g);
        pr0 = calcpr(SimulateData(Dhg,est,T+1,'Arrest',0));
        for f = 1:nf
            AmeSkillGRP(f,h,g) = calcpr(SimulateData(Dhg,est,T+1,'theta',addtheta(f,:),'Arrest',0)) - pr0;
        end   
        BasePr(1,h,g) = pr0;
    end
    
end

AmeSkillGRP = reshape(AmeSkillGRP,[nf 3 2 3]); % skill hgc gender race
AmeSkillGRP = permute(AmeSkillGRP,[1 3 2 4]); % skill gender hgc race
AmeSkillGRP = cat(2,AmeSkillGRP(:,2,:,:),AmeSkillGRP(:,1,:,:)-AmeSkillGRP(:,2,:,:));
AmeSkillGRP = reshape(AmeSkillGRP,[nf 2*3 3]);

skillnames = {'Family','Math/Verbal','Behavior'};
AmeSkill_White = [skillnames' num2cell(AmeSkillGRP(:,:,1))];
AmeSkill_Black = [skillnames' num2cell(AmeSkillGRP(:,:,2))];
AmeSkill_Hisp = [skillnames' num2cell(AmeSkillGRP(:,:,3))];

BasePr = reshape(BasePr,[1 3 2 3]); % 1 hgc gender race
BasePr = permute(BasePr,[1 3 2 4]); % 1 gender hgc race
BasePr = cat(2,BasePr(:,2,:,:),BasePr(:,1,:,:)-BasePr(:,2,:,:));
BasePr = reshape(BasePr,[1 2*3 3]);

labpr = {'Base Cond. Prob.'};
BasePr_White = [labpr num2cell(BasePr(:,:,1))];
BasePr_Black = [labpr num2cell(BasePr(:,:,2))];
BasePr_Hisp = [labpr num2cell(BasePr(:,:,3))];

OUTPUT = struct();
OUTPUT.AmeSkill_White = AmeSkill_White;
OUTPUT.AmeSkill_Black = AmeSkill_Black;
OUTPUT.AmeSkill_Hisp = AmeSkill_Hisp;
OUTPUT.BasePr_White = BasePr_White;
OUTPUT.BasePr_Black = BasePr_Black;
OUTPUT.BasePr_Hisp = BasePr_Hisp;


