function TBL = latextbl(X,fname,numformat,showstderr,showstars)

numBS = numel(X)-1;

ISnum = cellfun(@(x) isnumeric(x),X{1});

TBL = X{1};
for i = reshape(find(ISnum),1,[])
    coef = X{1}{i};
    if showstderr
        coeflist = nan(numBS,1);
        for bs = 1:numBS
            coeflist(bs) = X{bs+1}{i};
        end
        coef_se = std(coeflist,0);
        if showstars
            critvals = abs(norminv([.10 .05 .01]./2));  
            nstars = sum(abs(coef./coef_se)>=critvals);   
            TBL{i} = [sprintf(numformat,coef) sprintf('$^{%s}$',repmat('\ast',[1 nstars])) ...
                        ' \newline { (' sprintf(numformat,coef_se) ')}'];
        else
            TBL{i} = [sprintf(numformat,coef) ...
                        ' \newline { (' sprintf(numformat,coef_se) ')}'];
        end
    else
        TBL{i} = sprintf(numformat,coef);        
    end
end
            
if ~isempty(fname)
    
TBLrows = arrayfun(@(r) [strjoin(TBL(r,:) ,' & ') '\\'],(1:size(TBL,1))','unif',0);
    
fid=fopen(fname,'w');
fwrite(fid,sprintf('%s \n',TBLrows {:}));
fclose(fid);

end