function combinelatextablebody(newname,varargin)

Ntabs = numel(varargin);

T = cell(1,Ntabs);
for t = 1:Ntabs
    fid = fopen(varargin{t},'r');
    C = textscan(fid, '%s', 'delimiter', '\n');
    C = cellfun(@(c) strsplit(c,'&'),C{1},'unif',0);
    C = vertcat(C{:});
    if t<Ntabs
        C(:,end) = cellfun(@(c) c(1:end-3),C(:,end),'unif',0);
    end
    if t>1
        C(:,1) = [];
    end
    T{t} = C;
end

T = cat(2,T{:});
numdatarows = size(T,1);
T = arrayfun(@(r) strjoin(T(r,:) ,' & '),(1:numdatarows)','unif',0);
    
fid=fopen(newname,'w');
fwrite(fid,sprintf('%s \n',T{:}));
fclose(fid);