function DATA = bootsamp(DATA,s)

if s~=0
    
    N = numel(DATA);
    pwt_total = sum(vertcat(DATA.pwt));
    
    rng(s)

    ids = randsample(N,2*N,true);

    ids_end = find(cumsum(vertcat(DATA(ids).pwt))>=pwt_total,1);
    
    ids = ids(1:ids_end);
    ids = tabulate(ids);
    ids = ids(ids(:,2)>0,1:2);
    ids_repeat = ids(:,2);
    ids = ids(:,1);
        
    DATA = DATA(ids);
    
    pwt = num2cell(vertcat(DATA.pwt).*ids_repeat);
    
    [DATA(:).pwt] = pwt{:};
    
    
end