
% Define a variable that contains the path to the main folder;
mainfold = '';

cd(fullfile(mainfold,'progs','latex output','tables'))

addpath(fullfile(mainfold,'progs','data'));
addpath(fullfile(mainfold,'progs','matlab functions'));
addpath(fullfile(mainfold,'progs','full model'));
addpath(fullfile(mainfold,'progs','results','factor model estimates'))
addpath(fullfile(mainfold,'progs','tables and figures'))

load('Gender Gap Data.mat')
load('FM_0','est')

N = numel(DATA);
[nf,~] = size(est.factmean);
        
expv = exp([zeros(N,1) vertcat(DATA.typeX)*est.typecoef]);
pr = bsxfun(@rdivide,expv,sum(expv,2));
mixpr = (vertcat(DATA.pwt)'*pr)./sum(vertcat(DATA.pwt));
priordist = gmdistribution(est.factmean',est.factcov,mixpr);
[priormean,priorcov] = gmdmoments(est.factmean,est.factcov,mixpr);
priorvar = diag(priorcov)';

numW = numel(est.meascoef);
[~,measorder] = sort({measInfo.name});
newnum = nan(1,numW);
newnum(measorder) = 1:numW;

numSamp = 1e5;
burnin = 1e5;
REDVAR = cell(numW,1);

parfor j = 1:numW
    
    if isinf(measInfo(j).type)
        C = 1;
    else
        C = measInfo(j).type;
    end
        
    redfrac = nan(C,nf);
    
    for c = 1:C
        
        if isinf(measInfo(j).type)
            measY = {[1 priormean']*est.meascoef{j}};
        else
            measY = {ismember((1:C),c)};
        end
        meascoef = est.meascoef(j);
        measvar = num2cell(est.measvar(j));
        
        rng(0,'twister')
        x = random(priordist,numSamp);
        L = zeros(numSamp,1);
        varx = nan(numSamp,nf);
        
        for i = 1:burnin
            x0 = random(priordist,numSamp);
            L0 = ones(numSamp,1);
            for m = 1:numel(measY)
                yhat = bsxfun(@plus,meascoef{m}(1,:),x0*meascoef{m}(2:end,:));
                if ~isnan(measvar{m})
                    L0 = L0.*normpdf(measY{m},yhat,sqrt(measvar{m}));
                else
                    expv = exp([zeros(numSamp,1) yhat]); 
                    pr = bsxfun(@rdivide,expv,sum(expv,2));
                    L0 = L0.*exp(log(pr)*measY{m}');
                end
            end
            accept_x = rand([numSamp 1])<=(L0./L);
            x(accept_x,:) = x0(accept_x,:);
            L(accept_x) = L0(accept_x);      
            varx(i,:) = var(x,1);            
            
            seqlen = ceil(i/4);
            %seq1 = max((i-2*seqlen)+(1:2*seqlen),1);
            seq1 = max((i-seqlen)+(1:seqlen-1),1);
            seq2 = max((i-seqlen)+(1:seqlen),1);            
            convg_chk = mean(varx(seq1,:)) - mean(varx(seq2,:));            
            fprintf('%d of %d, %0.7f  \n',i,burnin,norm(convg_chk,inf));
            if (i>4) && (norm(convg_chk,inf)<1e-6)
                varx = mean(varx(seq2,:));
                break
            end
        end
        
        redfrac(c,:) = 1 - (varx./priorvar);
        
    end
    
    if isinf(measInfo(j).type)
        nomval = {'Continuous'};
    else
        if C==2
            nomval = {'No','Yes'}';
        elseif strcmp(measInfo(j).name,'family_income_group')
            nomval = {'Missing','$<$\$15K','$\ge$\$15k'}';
        elseif strfind(measInfo(j).name,'mom_parent_style')>0
            nomval = {'Uninvolved','Permissive','Authoritarian','Authoritative'}';
        elseif any(strcmp(measInfo(j).name,{'MomDegree','DadDegree'}))
            nomval = {'Missing','HS Dropout','HS Deg.','Some Col.','Col. Deg.'}';
        else
            nomval = repmat({''},C,1);
        end
    end
    
    rname = cell(C,1);
    rname{1} = [num2str(newnum(j)) '. ' strrep(measInfo(j).name,'_',' ')];
    REDVAR{j} = [rname nomval num2cell(max(redfrac,0))]; 
    
end    
REDVAR_OUT = cat(1,REDVAR{measorder});

latextbl({REDVAR_OUT},'VarRed.tex','%0.3f',false,false);





