
% Define a variable that contains the path to the main folder;
mainfold = '';

cd(fullfile(mainfold,'progs','latex output','tables'))

addpath(fullfile(mainfold,'progs','matlab functions'));
addpath(fullfile(mainfold,'progs','results','output'));

clear RES1 RES2
for bs = 0:50
    OUT = load(sprintf('OUT_%d.mat',bs),'TBL_AmeByGrd','TBL_RFAmeByGrd');
    RES1(bs+1) = OUT.TBL_AmeByGrd;
    RES2(bs+1) = OUT.TBL_RFAmeByGrd;
end

ArrestFM = cellfun(@(x) x(3,:),{RES1.AME_Costs},'unif',0);
ArrestRF = cellfun(@(x) x(3,:),{RES2.AME_Costs},'unif',0);

latextbl(ArrestFM,'AmeByGrdCosts.tex','%0.3f',true,true);
latextbl(ArrestRF,'RFAmeByGrdCosts.tex','%0.3f',true,true);


