
% Define a variable that contains the path to the main folder;
mainfold = '';

cd(fullfile(mainfold,'progs','latex output','tables'))

addpath(fullfile(mainfold,'progs','matlab functions'));
addpath(fullfile(mainfold,'progs','results','output'));

clear RES
for bs = 0:50
    OUT = load(sprintf('OUT_%d.mat',bs),'TBL_FactorSummary');
    RES(bs+1) = OUT.TBL_FactorSummary;
end

FactMean_White = latextbl({RES.FactorMeanNorm_White},[],'%0.3f',true,true);
FactMean_Black = latextbl({RES.FactorMeanNorm_Black},[],'%0.3f',true,true);
latextbl({RES.FactorMeanNorm_Hisp},'FactorMomentsMeanNorm_Hispanic.tex','%0.3f',true,true);
latextbl({[FactMean_Black FactMean_White(:,2:end)]},'FactorMomentsMeanNorm_BlackWhite.tex',[],false,false);

latextbl({RES.FactorMOM1_All},'FactorMomentsAppendAll1.tex','%0.3f',true,false);
latextbl({RES.FactorMOM2_All},'FactorMomentsAppendAll2.tex','%0.3f',true,false);
latextbl({RES.FactorMOM3_All},'FactorMomentsAppendAll3.tex','%0.3f',true,false);
latextbl({RES.TypeInfo},'FactorMomentsTypeInfo.tex','%0.3f',false,false);

latextbl({RES.FactorMOM1_White},'FactorMomentsAppendWhite1.tex','%0.3f',true,false);
latextbl({RES.FactorMOM2_White},'FactorMomentsAppendWhite2.tex','%0.3f',true,false);

latextbl({RES.FactorMOM1_Black},'FactorMomentsAppendBlack1.tex','%0.3f',true,false);
latextbl({RES.FactorMOM2_Black},'FactorMomentsAppendBlack2.tex','%0.3f',true,false);

latextbl({RES.FactorMOM1_Hisp},'FactorMomentsAppendHispanic1.tex','%0.3f',true,false);
latextbl({RES.FactorMOM2_Hisp},'FactorMomentsAppendHispanic2.tex','%0.3f',true,false);
