
% Define a variable that contains the path to the main folder;
mainfold = '';

cd(fullfile(mainfold,'progs','latex output','tables'))

addpath(fullfile(mainfold,'stata'));
addpath(fullfile(mainfold,'progs','data'));
addpath(fullfile(mainfold,'progs','matlab functions'));

rord = {'black','black_male','white','white_male','hispanic','hispanic_male'};

tab_sum = struct();

for t1 = {'math_verb','behave','fam'}
    T = readtable(sprintf('%s_sum.csv',t1{1}),'Delimiter',',','ReadVariableNames',false);
    T = table2cell(T);
    T = cellfun(@(x) strrep(x,'=',''),T,'unif',0);
    T = cellfun(@(x) strrep(x,'"',''),T,'unif',0);

    T = cellfun(@(x) strrep(x,'***','$^{\ast\ast\ast}$'),T,'unif',0);
    T = cellfun(@(x) strrep(x,'**','$^{\ast\ast}$'),T,'unif',0);
    T = cellfun(@(x) strrep(x,'*','$^{\ast}$'),T,'unif',0);
        
    [~,nuord] = ismember(rord,T(:,1));            
    T(ismember(T(:,1),rord),:) = T(nuord,:);
           
    T([1 (end) (end-1)],:) = [];
    T = T';
    T(1,:) = [];            
            
    if strcmp(t1{1},'fam')
        T{strcmp(T(:,1),'m_degree_4'),1} = 'Mother College Degree';
        T{strcmp(T(:,1),'family_members'),1} = 'Num. in Family Under 18';
        T{strcmp(T(:,1),'brokenhh'),1} = 'Broken Family ';
        T{strcmp(T(:,1),'family_income'),1} = 'Family Income';
    elseif strcmp(t1{1},'behave')   
        T{strcmp(T(:,1),'susp'),1} = 'Suspensions';
        T{strcmp(T(:,1),'retention'),1} = 'School Retention';
        T{strcmp(T(:,1),'gpain8'),1} = 'GPA in Grade 8';
        T{strcmp(T(:,1),'sex'),1} = 'Precocious Sex';
        T{strcmp(T(:,1),'attack'),1} = 'Attack';
        T{strcmp(T(:,1),'substance'),1} = 'Any Illegal Substance Use';   
    elseif strcmp(t1{1},'math_verb')   
        T{strcmp(T(:,1),'asvab_ar_age_normed'),1} = 'ASVAB Arithmetic Reas.';
        T{strcmp(T(:,1),'asvab_mk_age_normed'),1} = 'ASVAB Math Knowledge';
        T{strcmp(T(:,1),'asvab_pc_age_normed'),1} = 'ASVAB Paragraph Comp.';
        T{strcmp(T(:,1),'asvab_wk_age_normed'),1} = 'ASVAB Word Knowledge';
    end
                
    T(:,[2 4 6]) = cellfun(@(x) strrep(x,'\ast',''),T(:,[2 4 6]),'unif',0);
    tab_sum.(t1{1}) = T;

end

latextbl({tab_sum.fam},'SumVarFam.tex',[],false,false);
latextbl({tab_sum.math_verb},'SumVarMathVerbal.tex',[],false,false);
latextbl({tab_sum.behave([6 5 4],:)},'SumVarBehave.tex',[],false,false);
latextbl({tab_sum.behave([1 3 2],:)},'SumVarSchool.tex',[],false,false);


        
        