
% Define a variable that contains the path to the main folder;
mainfold = '';

cd(fullfile(mainfold,'progs','latex output','tables'))

addpath(fullfile(mainfold,'progs','matlab functions'));
addpath(fullfile(mainfold,'progs','results','output'));

clear RES
for bs = 0:50
    OUT = load(sprintf('OUT_%d.mat',bs),'TBL_EducationGap');
    RES(bs+1) = OUT.TBL_EducationGap;
end

EqSkill_WhiteA = latextbl({RES.EqSkill_White},[],'%0.3f',false,false);
EqSkill_WhiteB = latextbl({RES.EqSkill_White},[],'%0.3f',true,true);
latextbl({[EqSkill_WhiteA(:,1:2) EqSkill_WhiteB(:,3:end)]},'EducationGapEqSkillWhite.tex',[],false,false);

EqSkill_BlackA = latextbl({RES.EqSkill_Black},[],'%0.3f',false,false);
EqSkill_BlackB = latextbl({RES.EqSkill_Black},[],'%0.3f',true,true);
latextbl({[EqSkill_BlackA(:,1:2) EqSkill_BlackB(:,3:end)]},'EducationGapEqSkillBlack.tex',[],false,false);

EqSkill_HispA = latextbl({RES.EqSkill_Hisp},[],'%0.3f',false,false);
EqSkill_HispB = latextbl({RES.EqSkill_Hisp},[],'%0.3f',true,true);
latextbl({[EqSkill_HispA(:,1:2) EqSkill_HispB(:,3:end)]},'EducationGapEqSkillHispanic.tex',[],false,false);

newrows = {'Black Male v. Black Female';'Black Male v. White Male';'Black Female v. White Female'};
WFSkillgap_Black = cellfun(@(p,r) [p' r'],{RES.WFbasegap_Black},{RES.WFSkillgap_Black},'unif',0);
WFSkillgap_Black = cellfun(@(x) [newrows x(2:end,:)],WFSkillgap_Black,'unif',0);
latextbl(WFSkillgap_Black,'EducationGapWFSkillBlack.tex','%0.3f',true,true);

newrows = {'Hispanic Male v. Hispanic Female';'Hispanic Male v. White Male';'Hispanic Female v. White Female'};
WFSkillgap_Hisp = cellfun(@(p,r) [p' r'],{RES.WFbasegap_Hisp},{RES.WFSkillgap_Hisp},'unif',0);
WFSkillgap_Hisp = cellfun(@(x) [newrows x(2:end,:)],WFSkillgap_Hisp,'unif',0);
latextbl(WFSkillgap_Hisp,'EducationGapWFSkillHispanic.tex','%0.3f',true,true);
