
% Define a variable that contains the path to the main folder;
mainfold = '';

cd(fullfile(mainfold,'progs','latex output','tables'))

addpath(fullfile(mainfold,'progs','data'));
addpath(fullfile(mainfold,'progs','matlab functions'));

load('summary data age 24')
numGRP = max(D.grp);

EdSum = nan(3,numGRP);
EdN = nan(1,numGRP); 
for g = 1:numGRP
    I = (D.grp==g) & (~isnan(D.hgc24));
    hgc = D.hgc24(I);
    w = D.wt_R1(I);
    EdN(g) = nnz(I);
    EdSum(1,g) = (w'*(hgc<=11))/sum(w);
    EdSum(2,g) = (w'*(hgc==12))/sum(w);
    EdSum(3,g) = (w'*(hgc>=13))/sum(w);
end

EdSum = reshape(EdSum,[3 2 3]);
EdSum = EdSum(:,:,[2 1 3]);
EdSum = reshape(EdSum,[3 numGRP]);

ednames = {'High School Dropout','High School Degree Only','College Enrollment'};
latextbl({[ednames' num2cell(100*EdSum)]},'SumEdPercent.tex','%0.1f',false,false);

EdN = reshape(EdN,[1 2 3]);
EdN = EdN(:,:,[2 1 3]);
EdN = reshape(EdN,[1 numGRP]);

latextbl({[{'Observations'} num2cell(EdN)]},'SumEdObs.tex','%0.0f',false,false);
