
% Define a variable that contains the path to the main folder;
mainfold = '';

cd(fullfile(mainfold,'progs','latex output','figures'))

addpath(fullfile(mainfold,'progs','matlab functions'));
addpath(fullfile(mainfold,'progs','data'));
addpath(fullfile(mainfold,'progs','results','output'));


plotformat = {'interpreter', 'latex','FontUnits','points','FontWeight','normal','FontSize',10,'FontName','Times'};
axisformat = {'FontUnits','points','FontWeight','normal','FontSize',10,'FontName','Times'};

skillnames = {'Family','Math/Verbal','Behavior'};
nf = numel(skillnames);
racenames = {'White','Black','Hispanic'};

Y = load('OUT_0.mat','FIG_DynamicSelection');
Y = Y.FIG_DynamicSelection.Y;

load('Gender Gap Data.mat')
NGRP = vertcat(DATA.pwt)'*bsxfun(@eq,vertcat(DATA.grp),(1:6));
NGRP = reshape(NGRP,[1 1 2 3]);
YALL = bsxfun(@rdivide,sum(bsxfun(@times,Y,NGRP),4),sum(NGRP,4));
x = (9:16)';

%OVERALL plot
figratio = 1/3;
footer = .11;
close all
pos = get(gcf,'Position');
pos(4) = pos(3)*figratio;
set(gcf,'Position',pos)
    
for f = 1:nf
    if f==1
        OUTPOS = [0 footer (1/3) (1-footer)];
    elseif f==2
        OUTPOS = [(1/3) footer (1/3) (1-footer)];
    elseif f==3
        OUTPOS = [(2/3) footer (1/3) (1-footer)];
    end
        
    subplot(1,nf,f)
    set(gca,'YTick',[-.25 0 .25 .5 .75 1],'XLim',[x(1) x(end)],'XTick',x,...
            'Ylim',[-.25 1],'TickLength',[ .01 0 ],...
            'XTickLabel',{'9+','10+','11+','12+','13+','14+','15+','16+'},...
            'OuterPosition',OUTPOS,axisformat{:})
    title([skillnames{f}],plotformat{:})
    hold on
    plot(x,YALL(x,f,1),'-k')
    plot(x,YALL(x,f,2),'--k')
end
hL = legend({'Males','Females'},'Orientation','horizontal');
set(hL,'Position',[0.4 0.04 0.2393 0.03]);
set(gcf,'PaperPositionMode', 'manual','PaperUnits','inches'...
    ,'PaperPosition',[0 0 [1 figratio]*5.95],'PaperSize',[1 figratio]*5.95)

print('-dpdf','DynSelAll.pdf','-r2000')


%By Race Plot
close all
figure('PaperPositionMode', 'manual','PaperUnits','inches', 'PaperSize', [8.5 6],'PaperPosition', [0 0 8.5 6]);
x = (9:16)';
i = 1;
for f = 1:nf
    for r = [2 1 3]
        my_subplot = subplot(3,3,i);
        plot(x,Y(x,f,1,r),'-k',x,Y(x,f,2,r),'--k')
        title([racenames{r} ' -- ' skillnames{f}],plotformat{:})
        set(my_subplot,'TickLength',[ .01 0 ],axisformat{:});
        ax = gca;
        ax.XLim = [x(1) x(end)];
        ax.XTick = x;
        ax.XTickLabel = {'9+','10+','11+','12+','13+','14+','15+','16+'};
        ax.YLim = [-1.1 1.1];
        ax.YTick = [-1 -.5 0 .5 1];
        i = i + 1;
    end
end
hL = legend({'Males','Females'},'Orientation','horizontal');
set(hL,'Position',[0.4 0.03 0.2393 0.0357]);

print('-dpdf','DynSelByRaceAppend.pdf','-r2000')

