
% Define a variable that contains the path to the main folder;
mainfold = '';

cd(fullfile(mainfold,'progs','latex output','figures'))

addpath(fullfile(mainfold,'progs','data'));
addpath(fullfile(mainfold,'progs','matlab functions'));
addpath(fullfile(mainfold,'progs','results','simulated factors'));

plotformat = {'interpreter', 'latex','FontUnits','points','FontWeight','normal','FontSize',10,'FontName','Times'};
axisformat = {'FontUnits','points','FontWeight','normal','FontSize',10,'FontName','Times'};

skillnames = {'Family','Math/Verbal','Behavior'};
nf = numel(skillnames);
racenames = {'White','Black','Hispanic'};

load('Gender Gap Data.mat')
DATA = kpfield(DATA,{'grp','pwt'});
load('SIM_0','theta_i');
R = size(theta_i,2);
DATA = repmat(DATA,[1 R]);
[DATA(:).theta] = theta_i{:};
DATA = DATA(:);
DATA = structureA2V(DATA);
clear theta_i

numGRP = max(vertcat(DATA.grp));

numpts = 1000;
xrange = arrayfun(@(l,r) linspace(l,r,numpts)',[2.9,2.5,-4.1],[4.8,4.75,0.1],'unif',0);

Y = zeros(numpts,nf,numGRP);
for g = 1:numGRP
    I = (DATA.grp==g);
    for f = 1:nf
        Y(:,f,g) = ksdensity(DATA.theta(I,f),xrange{f},'Weights',DATA.pwt(I));
    end    
end
Y = reshape(Y,[numpts nf 2 3]);

YALL = zeros(numpts,nf,2);
for g = 1:2
    if g==1
        I = ismember(DATA.grp,[1 3 5]);
    elseif g==2
        I = ismember(DATA.grp,[2 4 6]);
    end
    for f = 1:nf
        YALL(:,f,g) = ksdensity(DATA.theta(I,f),xrange{f},'Weights',DATA.pwt(I));
    end   
end
   
%Overall
figratio = 1/3;
footer = .11;
close all
pos = get(gcf,'Position');
pos(4) = pos(3)*figratio;
set(gcf,'Position',pos)
for f = 1:nf
    if f==1
        OUTPOS = [0 footer (1/3) (1-footer)];
        XTIK = (3:.5:4.5);
    elseif f==2
        OUTPOS = [(1/3) footer (1/3) (1-footer)];
        XTIK = (2:.5:4.5);
    elseif f==3
        OUTPOS = [(2/3) footer (1/3) (1-footer)];
        XTIK = (-4:1:0);
    end
        
    subplot(1,nf,f)
    set(gca,'YTick',[],'XLim',[xrange{f}(1) xrange{f}(end)],'XTick',XTIK,...
            'Ylim',[0 1.1*max(reshape(Y(:,f,:,:),[],1))],'TickLength',[ .01 0 ],...
            'OuterPosition',OUTPOS,axisformat{:})
    title([skillnames{f}],plotformat{:})
    hold on
    plot(xrange{f},YALL(:,f,1),'-k')
    plot(xrange{f},YALL(:,f,2),'--k')
    end
hL = legend({'Males','Females'},'Orientation','horizontal');
set(hL,'Position',[0.4 0.04 0.2393 0.03]);
set(gcf,'PaperPositionMode', 'manual','PaperUnits','inches'...
    ,'PaperPosition',[0 0 [1 figratio]*5.95],'PaperSize',[1 figratio]*5.95)

print('-dpdf','SkillDist_ALL.pdf','-r2000')

% by race
figratio = 1;
footer = .06;
close all
pos = get(gcf,'Position');
pos(4) = pos(3)*figratio;
set(gcf,'Position',pos)
i = 1;
hi = (1-footer)/3;
wi = (1/3);
for r = [2 1 3]
    for f = 1:nf  
        OUTPOS = [nan nan wi hi];
        if ismember(i,[1 4 7])
            OUTPOS(1) = 0;
        elseif ismember(i,[2 5 8])
            OUTPOS(1) = wi;
        elseif ismember(i,[3 6 9])
            OUTPOS(1) = wi*2;
        end
        if ismember(i,[1 2 3])
            OUTPOS(2) = footer+2*hi;
        elseif ismember(i,[4 5 6])
            OUTPOS(2) = footer+1*hi;
        elseif ismember(i,[7 8 9])
            OUTPOS(2) = footer;
        end
        
        if f==1
            XTIK = (3:.5:4.5);
        elseif f==2
            XTIK = (2:.5:4.5);
        elseif f==3
            XTIK = (-4:1:0);
        end
        
        subplot(3,nf,i)
        set(gca,'YTick',[],'XLim',[xrange{f}(1) xrange{f}(end)],'XTick',XTIK,...
            'Ylim',[0 1.1*max(reshape(Y(:,f,:,:),[],1))],'TickLength',[ .01 0 ],...
            'OuterPosition',OUTPOS,axisformat{:})
        title([racenames{r} ' -- ' skillnames{f}],plotformat{:})
        hold on
        plot(xrange{f},Y(:,f,1,r),'-k')
        plot(xrange{f},Y(:,f,2,r),'--k')
    
        i = i + 1;

    end
end
hL = legend({'Males','Females'},'Orientation','horizontal');
set(hL,'Position',[0.4 0.02 0.2393 0.0268]);
set(gcf,'PaperPositionMode', 'manual','PaperUnits','inches'...
    ,'PaperPosition',[0 0 [1 figratio]*5.95],'PaperSize',[1 figratio]*5.95)
print('-dpdf','SkillDist_ByRace.pdf','-r2000')


%{

for r = 1:3
    
    figratio = 1/3;
    footer = .11;
    close all
    pos = get(gcf,'Position');
    pos(4) = pos(3)*figratio;
    set(gcf,'Position',pos)
    
    for f = 1:nf
        if f==1
            OUTPOS = [0 footer (1/3) (1-footer)];
            XTIK = (3:.5:4.5);
        elseif f==2
            OUTPOS = [(1/3) footer (1/3) (1-footer)];
            XTIK = (2:.5:4.5);
        elseif f==3
            OUTPOS = [(2/3) footer (1/3) (1-footer)];
            XTIK = (-4:1:0);
        end
        
        subplot(1,nf,f)
        set(gca,'YTick',[],'XLim',[xrange{f}(1) xrange{f}(end)],'XTick',XTIK,...
            'Ylim',[0 1.1*max(reshape(Y(:,f,:,:),[],1))],'TickLength',[ .01 0 ],...
            'OuterPosition',OUTPOS,axisformat{:})
        title([racenames{r} ' -- ' skillnames{f}],plotformat{:})
        hold on
        plot(xrange{f},Y(:,f,1,r),'-k')
        plot(xrange{f},Y(:,f,2,r),'--k')
    end
    hL = legend({'Males','Females'},'Orientation','horizontal');
    set(hL,'Position',[0.4 0.04 0.2393 0.03]);
    set(gcf,'PaperPositionMode', 'manual','PaperUnits','inches'...
    ,'PaperPosition',[0 0 [1 figratio]*5.95],'PaperSize',[1 figratio]*5.95)
    print('-dpdf',sprintf('SkillDist_%s.pdf',racenames{r}),'-r2000')
end
%}      
    