function [suffstats,L,theta_i] = SuffStatsFun(D,est,R,samplemethod)

[numFact,numType] = size(est.factmean);
numW = numel(est.meascoef);

type_x = D.typeX;
expv = exp([0 type_x*est.typecoef]);            
typepr0 = bsxfun(@rdivide,expv,sum(expv,2));
E = est.factmean;
V = est.factcov;
    
if strcmp(samplemethod,'independent')
    typeI = randsample(numType,R,true,typepr0);
elseif strcmp(samplemethod,'mass')
    RperType = ceil(R/numType);
    R = RperType*numType;
    typeI = reshape(ones(RperType,1)*(1:numType),[],1);
end
theta_i = mvnrnd(E(:,typeI)',V);

% likelihood of measurements
meas_x = [ones(R,1) theta_i];
meas_y = cell(1,numW);
L_meas = ones(R,1);
for j = find(D.measHas)
    if ~isnan(est.measvar(j))
        L = normpdf(D.measY{j},meas_x*est.meascoef{j},sqrt(est.measvar(j)));
    else
        meas_y{j} = repmat(D.measY{j},[R 1]);
        expv = exp([zeros(size(meas_x,1),1) meas_x*est.meascoef{j}]);            
        pr = bsxfun(@rdivide,expv,sum(expv,2));
        L = prod(pr.^meas_y{j},2);
        meas_y{j} = meas_y{j}(:,2:end) - pr(:,2:end);
    end
    L_meas = L_meas.*L; 
end

thetaIgrp = Igrp(theta_i,D.grp);

% likelihood promotion
prom_x = cell(1,15);
prom_y = cell(1,15);
L_prom = ones(R,1);
for h = D.promHas
    prom_x{h} = [repmat(D.promX{h},[R 1]) thetaIgrp(ones(D.promN(h),1)*(1:R),:)];
    prom_y{h} = repmat(D.promY{h},[R 1]);
    expv = exp([zeros(size(prom_x{h},1),1) prom_x{h}*est.promcoef(:,h)]);    
    pr = bsxfun(@rdivide,expv,sum(expv,2));
    L = prod(reshape(prod(pr.^prom_y{h},2),[D.promN(h) R]),1)';    
    prom_y{h} = prom_y{h}(:,2:end) - pr(:,2:end);
    L_prom = L_prom.*L;
end

% likelihood arrest
L_arrest =ones(R,1);
if D.arrestN>0
    arrest_x = [repmat(D.arrestX,[R 1]) theta_i(ones(D.arrestN,1)*(1:R),:)];
    arrest_y = repmat(D.arrestY,[R 1]);
    expv = exp([zeros(size(arrest_x,1),1) arrest_x*est.arrestcoef]);    
    pr = bsxfun(@rdivide,expv,sum(expv,2));
    L_arrest = prod(reshape(prod(pr.^arrest_y,2),[D.arrestN R]),1)';  
    arrest_y = arrest_y(:,2:end) - pr(:,2:end);    
end

% Complete Likleihood

switch est.model
    case 'meas only'
        L = L_meas;
    case 'meas and prom'
        L = L_prom.*L_meas;
    case 'full'
        L = L_arrest.*L_prom.*L_meas;
    otherwise
        error('unrecognized model in estimation structure')
end

if strcmp(samplemethod,'independent')
    ll = log(sum(L)/R); 
elseif strcmp(samplemethod,'mass')
    L = reshape(typepr0(typeI),[],1).*L;
    ll = log(sum(L)/RperType); 
end

if nargout>1
    suffstats = [];
    return
end

qi = L./sum(L);

%% Suff Stats for Distribution 
theta_pdf = zeros(R,numType);
for k = 1:numType
    theta_pdf(:,k) = mvnpdf(theta_i,est.factmean(:,k)',est.factcov);
end
typewt = bsxfun(@times,typepr0,theta_pdf);
typewt = bsxfun(@rdivide,typewt,sum(typewt,2));
typewt = bsxfun(@times,qi,typewt);

Nfact = sum(typewt,1);
Sfact = theta_i'*typewt;
Sfact2 = bsxfun(@times,theta_i,reshape(theta_i,[R 1 numFact]));
Sfact2 = reshape(Sfact2,[R numFact^2])'*typewt;

if numType>1
    type_y = sum(Nfact(:,2:end),1) - typepr0(2:end);
else
    type_y = zeros(1,0);
end

%% Suff Stats for meas coef and meas var
wtmeas_x = bsxfun(@times,qi,meas_x);
meas_xx = wtmeas_x'*meas_x;
meas_x = sum(wtmeas_x)';
meas_xy = cell(1,numW);
for j = find(D.measHas & isnan(est.measvar))
    meas_xy{j} = (wtmeas_x'*meas_y{j});
end

%% Suff Stats for promotion
prom_xx = cell(1,15);
prom_xy = cell(1,15);
for h = D.promHas
    wtprom_x = bsxfun(@times,qi(ones(D.promN(h),1)*(1:R),1),prom_x{h});
    prom_xx{h} = wtprom_x'*prom_x{h};
    prom_xy{h} = wtprom_x'*prom_y{h};
end

%% Suff Stats for arrest
arrest_xx = [];
arrest_xy = [];
if D.arrestN>0
    wtarrest_x = bsxfun(@times,qi(ones(D.arrestN,1)*(1:R),1),arrest_x);
    arrest_xx = wtarrest_x'*arrest_x;
    arrest_xy = wtarrest_x'*arrest_y;
end

suffstats = struct('ll',ll,...
    'type_y',type_y,...
    'Sfact',Sfact,'Nfact',Nfact,'Sfact2',Sfact2,...
    'meas_x',meas_x,'meas_xx',meas_xx);
suffstats.meas_xy = meas_xy;
suffstats.prom_xx = prom_xx;
suffstats.prom_xy = prom_xy;
suffstats.arrest_xx = arrest_xx;
suffstats.arrest_xy = arrest_xy;

end
