function est = MM(DATA,R,sv,emopt)

[numFact,numType] = size(sv.factmean);

N = size(DATA,1);
pwt = vertcat(DATA.pwt);

pwt_dist = reshape(pwt,1,1,[]);

measHas = vertcat(DATA.measHas);
pwt_meas = bsxfun(@times,pwt,measHas);
pwt_meas = mat2cell(pwt_meas,size(pwt_meas,1),ones(1,size(pwt_meas,2)));
pwt_meas = cellfun(@(x) reshape(nonzeros(x),1,1,[]),pwt_meas,'unif',0);
measY = vertcat(DATA.meas);

pwt_prom = bsxfun(@times,pwt,vertcat(DATA.promN)>0);
pwt_prom = mat2cell(pwt_prom,size(pwt_prom,1),ones(1,size(pwt_prom,2)));
pwt_prom = cellfun(@(x) reshape(nonzeros(x),1,1,[]),pwt_prom,'unif',0);

pwt_arrest = reshape(pwt(vertcat(DATA.arrestN)>0),1,1,[]);

type_x = vertcat(DATA.typeX);
wttype_x = bsxfun(@times,pwt,type_x);
type_xx = wttype_x'*type_x;

function [est,ll] = calc(est)
    
    suffstats(N,1) = struct('ll',[],'Sfact',[],'Nfact',[],'Sfact2',[],'type_y',[],...
        'meas_x',[],'meas_xx',[],'meas_xy',[],'prom_xx',[],'prom_xy',[],...
        'arrest_xx',[],'arrest_xy',[]);

    parfor i = 1:N
        rng(i,'twister')
        suffstats(i,1) = SuffStatsFun(DATA(i),est,R,'mass');
    end
     
    ll = cat(2,suffstats.ll)*pwt; 
 
    Sfact = sum(bsxfun(@times,pwt_dist,cat(3,suffstats.Sfact)),3);
    Nfact = sum(bsxfun(@times,pwt_dist,cat(3,suffstats.Nfact)),3);
    est.factmean = bsxfun(@rdivide,Sfact,Nfact);
  
    Sfact2 = sum(bsxfun(@times,pwt_dist,cat(3,suffstats.Sfact2)),3);
    Sfact2 = reshape(Sfact2,[numFact numFact numType]);
    Sfactresid2 = zeros([numFact numFact numType]);
    for k = 1:numType
        Sfactresid2(:,:,k) = Sfact2(:,:,k)...
                            - est.factmean(:,k)*Sfact(:,k)'...
                            - Sfact(:,k)*est.factmean(:,k)'...
                            + Nfact(k)*est.factmean(:,k)*est.factmean(:,k)';
    end
    factcov = sum(Sfactresid2,3)./sum(Nfact);
    if isdiag(est.factcov)
        est.factcov = diag(diag(factcov));
    else
        est.factcov = (factcov + factcov')./2;
    end

    type_xy = wttype_x'*cat(1,suffstats.type_y);
    est.typecoef = updateReg(type_xx,type_xy,est.typecoef,'discrete');
  
    meas_x = cat(2,suffstats.meas_x);
    meas_xx = cat(3,suffstats.meas_xx);
    meas_xy = vertcat(suffstats.meas_xy);
    for j = 1:numel(est.meascoef)
        I = measHas(:,j);
        XX = sum(bsxfun(@times,pwt_meas{j},meas_xx(:,:,I)),3);
        if ~isnan(est.measvar(j))
            Y = measY(I,j);
            wtY = Y.*reshape(pwt_meas{j},[],1);
            XY = meas_x(:,I)*wtY;
            YY = wtY'*Y;
            c = updateReg(XX,XY,est.meascoef{j},'continuous');
            SSR = (YY - c'*XY - XY'*c + c'*XX*c);
            est.meascoef{j} = c;
            est.measvar(j) = SSR./sum(pwt_meas{j});
        else
            XY = sum(bsxfun(@times,pwt_meas{j},cat(3,meas_xy{:,j})),3);
            est.meascoef{j} = updateReg(XX,XY,est.meascoef{j},'discrete');
        end
    end
 
    prom_xx = vertcat(suffstats.prom_xx);
    prom_xy = vertcat(suffstats.prom_xy);
    for h = 9:15
        XX = sum(bsxfun(@times,pwt_prom{h},cat(3,prom_xx{:,h})),3);
        XY = sum(bsxfun(@times,pwt_prom{h},cat(3,prom_xy{:,h})),3);
        est.promcoef(:,h) = updateReg(XX,XY,est.promcoef(:,h),'discrete');
    end
    
    XX = sum(bsxfun(@times,pwt_arrest,cat(3,suffstats.arrest_xx)),3);
    XY = sum(bsxfun(@times,pwt_arrest,cat(3,suffstats.arrest_xy)),3);
    est.arrestcoef = updateReg(XX,XY,est.arrestcoef,'discrete');
   
end
    
p2p = vecparm(sv);
est = em_alg(@calc,sv,p2p,emopt{:});
%est = em_alg_gsq(@calc,sv,p2p,emopt{:});

end


