
proc transpose data=frawdata.monthly (rename=(R0000100=id)) out=monthly;
	by id;
run;

data monthly;
	set monthly;

	yr = substr(_label_,1,4)+0;

	Lpos = find(_label_," L",length(_label_)-6);
	spcpos = find(_label_," ",Lpos+2);
	mon = substr(_label_,Lpos+2,spcpos-Lpos-2)+0;
	
	length lab $20.;
	if index(_label_,"SCH: ENROLLMENT STATUS")>0 then lab = "HS_status ";
		else if index(_label_,"COLLEGE: ENROLLMENT STATUS")>0 then lab="COL_Status";
		else if index(_label_,"ARREST STATUS")>0 then lab = "num_arrest";
			
	drop Lpos spcpos;
run;

proc sort data=monthly; by id yr mon; run;

proc transpose data=monthly out=monthly (drop=_name_);
	by id yr mon;
	id lab;
	var col1;
run;

data monthly;
	set monthly;
	cm = (yr-1980)*12 + mon;
run;

proc freq data=monthly; tables num_arrest col_status / missing; run;
		
	
