
proc transpose data=frawdata.behavior (rename=(R0000100=id)) out=behav; 
	by id; 
run;

data behav;
	set behav;
	roundyr=substr(_label_,length(_label_)-3,4)+0;		
	
	length data_type varlab $20.;
	
	if index(_label_,"SDLI")>0 then data_type = "SDLI";
		else if index(_label_,"AGE 1ST ")>0 then data_type = "agefst";
		else if index(_label_,"AGE LAST ")>0 then data_type = "agelst";
		else if index(_label_," EVER")>0 
			or index(_label_,"R ATTACKED TO HURT")>0 then data_type = "ever";
			
	if index(_label_," ATTACK")>0 then varlab = "attack";
		else if index(_label_," ALCOHOL")>0 
			or index(_label_," DRANK")>0  then varlab = "alcohol";
		else if index(_label_," MARIJUANA")>0 then varlab = "marij";
		else if index(_label_," SMOKE")>0 then varlab = "smoke";
		else if index(_label_," SEX")>0 then varlab = "sex";
run;

proc freq data = behav; tables data_type varlab / missing; run;

proc sort data = behav; by id varlab roundyr; run;

proc transpose data = behav out=behav (drop = _name_);
	by id varlab roundyr;
	id data_type;
	var col1;
run;

proc freq data = behav; tables sdli ever / list missing; run;

data behav_age (keep = id roundyr varlab agefst agelst)
	 behav_yr (keep = id roundyr varlab hasbehav);
	set behav;
	if agefst = agelst then agelst = .;
	hasbehav = max(sdli,ever);
	if agefst>0 or agelst>0 then output behav_age;
		else if hasbehav>=0 then output behav_yr;
run;

proc sort data = behav_yr; by id roundyr; run;
data behav_yr;
	merge behav_yr (in=a) 
		interview (in=b keep = id roundyr date where=(date ne .));
	by id roundyr;
	if a and b;
	yr = year(date);
	if month(date)<9 then yr = yr-1;
	keep id varlab hasbehav yr;
run;

proc transpose data = behav_age out=behav_age (drop = _name_ roundyr where=(col1>0));
	by id varlab roundyr;
	var agefst agelst;
run;

data behav_age_prob behav_age12;
	set behav_age;
	if col1<12 then output behav_age_prob;
		else output behav_age12;
run;
data behav_age_prob;
	set behav_age_prob;
	lab = "prob" || varlab;
	prob = 1;
run;
proc sort data = behav_age_prob nodupkey; by id lab prob; run;
proc freq data = behav_age_prob; tables lab; run;
proc transpose data = behav_age_prob out=behav_age_prob (drop = _name_);
	by id;
	id lab;
	var prob;
run;

data behav_age12;
	merge behav_age12 (in=a) individual (keep = id dob_month dob_year);
	by id;
	if a;
	yr = dob_year + col1;
	if dob_month<9 then yr = yr -1;
	hasbehav = 1;
	keep id yr hasbehav varlab;
run;

data behav2;
	set behav_age12 behav_yr;
run;
proc sort data = behav2; by id varlab yr hasbehav; run;
data behav2;
	set behav2;
	by id varlab yr hasbehav;
	if last.yr;
run;
proc sort data = behav2; by id yr; run;
proc transpose data = behav2 out=behav2 (drop = _name_);
	by id yr;
	id varlab;
	var hasbehav;
run;

data behavior;
	merge inc (in=a keep = id yr) behav2;
	by id yr;
	if a;
run;
data behavior;
	merge behavior (in=a) behav_age_prob;
	by id;
	if a;
run;
data behavior;
	set behavior;
	by id yr;
	
	array hasinfo {5} attackinfo alcoholinfo sexinfo marijinfo smokeinfo;
	array origvar {5} attack alcohol sex marij smoke;
	array probind {5} probattack probalcohol probsex probmarij probsmoke;
	retain attackinfo alcoholinfo sexinfo marijinfo smokeinfo;
	do i = 1 to 5;	
		if first.id then hasinfo{i} = 0;
		if first.id and probind{i} = . then hasinfo{i} = 1;
		if origvar{i}>=0 then hasinfo{i} = 1;
	end;
	drop i;
run;	
data behavior;
	set behavior;
	by id yr;
	
	array hasinfo {5} attackinfo alcoholinfo sexinfo marijinfo smokeinfo;
	array origvar {5} attack alcohol sex marij smoke;
	do i = 1 to 5;	
		if hasinfo{i} = 1 and origvar{i}=. then origvar{i}=0;
	end;
	drop i attackinfo alcoholinfo sexinfo marijinfo smokeinfo
		probattack probalcohol probsex probmarij probsmoke;
run;	
		
data behavior;
	set behavior;
	if yr<=2003;
run;	

proc means data = behavior sum; run;
	
proc datasets; delete behav behav_age behav_age_prob behav_age12 behav_yr behav2; run;
	
	








