program define members
version 10.1

*make ordered list of head/spouse and other household members

#delim ;

syntax, intvarnum(integer) reltype(integer) dfile(str) fileyear(integer);

tempfile temp;
tempvar headpid_temp mult;

  local intvar "er`intvarnum'";
  local f=`intvarnum'+1;
  local seqvar "er`f'";
  local f=`f'+1;
  local relvar "er`f'";
  local f=`f'+1;
  local agevar "er`f'";
  use er30001 er30002 er32000 `intvar' `seqvar' `relvar' `agevar'
    using `dfile'
    if er30001<=2930 & `seqvar'>=1 & `seqvar'<=20;

  gen double pid=10000000+er30001*1000+er30002;
  if `reltype'~=1 replace `relvar'=floor(`relvar'/10);
  gen double `headpid_temp'=pid if `relvar'==1;
  by `intvar', sort: egen double headpid=min(`headpid_temp');

  *food need and family size;
  preserve;
  recode `agevar' 0/3=3.9 4/6=4.6 7/9=5.5 10/12=6.4 13/15=7.4 16/20=8.7
    21/35=7.5 36/55=6.9 56/max=6.3 if er32000==1, copyrest test;
  recode `agevar' 0/3=3.9 4/6=4.6 7/9=5.5 10/12=6.3 13/15=6.9 16/20=7.2
    21/35=6.5 36/55=6.3 56/max=5.4 if er32000==2, copyrest test;
  recode `agevar' 0/3=3.9 4/6=4.6 7/9=5.5 10/12=6.35 13/15=7.15 16/20=7.95
    21/35=7 36/55=6.6 56/max=5.85 if er32000==9, copyrest test;
  collapse (sum) need`fileyear'=`agevar'
    (count) famsize`fileyear'=`agevar', by(`intvar') fast;
  recode famsize`fileyear' 1=1.2 2=1.1 3=1.05 4=1 5=.95 6/max=.9, 
    gen(`mult') test;
  *divide by 9: units are for man 21-35 living alone;
  replace need`fileyear'=need`fileyear'*`mult'/9;
  sort `intvar';
  save `temp', replace;
  restore;

  *heads and wives;
  preserve;
  keep if `relvar'==1 | `relvar'==2;
  keep pid `relvar' `intvar' headpid;
  reshape wide pid, i(`intvar') j(`relvar');
  egen hw`fileyear'=concat(pid1 pid2), format(%8.0f);
  replace hw`fileyear'=trim(subinstr(hw`fileyear',"."," ",.));
  keep `intvar' hw`fileyear' headpid;
  sort `intvar';
  merge `intvar' using `temp', unique;
  tab _merge;
  drop _merge;
  sort `intvar';
  save `temp', replace;
  restore;

  *everyone else;
  keep if `relvar'~=1 & `relvar'~=2;
  sort `intvar' pid;
  by `intvar': gen seq=_n;
  keep `intvar' pid seq;
  reshape wide pid, i(`intvar') j(seq);
  egen omemb`fileyear'=concat(pid*), format(%8.0f);
  replace omemb`fileyear'=trim(subinstr(omemb`fileyear',"."," ",.));
  keep `intvar' omemb`fileyear';

  *combine;
  sort `intvar';
  merge `intvar' using `temp', unique;
  tab _merge;
  drop _merge;
  rename `intvar' interview`fileyear';
  order interview`fileyear' headpid hw`fileyear' 
    omemb`fileyear' famsize`fileyear' need`fileyear';
  sort headpid;
  save data/loaded/members`fileyear'.dta, replace;
  sum *;
  drop _all;

#delim cr


end

