program gmm_compute_timeseparate
  version 9.2
  #delim ;
  syntax, coeffs(name) j(name) s(name) vcv(name) t(varname)
    [cluster(varname) center efficient];
  #delim cr

  *-- the IV estimator solves
  *     min_beta [Z'(y-Xbeta)]'W[Z'(y-Xbeta)]
  *     so beta=[X'Z*W*Z'X]^-1 * (X'Z)*W*[Z'y]
  *-- as standard in stata, however, we return a row vector that is the
  *     transpose of this formula -- it goes in coeffs

  *s: variance-covariance matrix of moment conditions is returned here
  *vcv: variance-covariance matrix of coefficients is returned here
  *efficient: weighting matrix is known to be efficient; use simplified
  *  calculation of vcv.
  *j : above objective function, holding beta fixed, using s in place of W

  *-- note: z should not contain constants or time dummies;
  *     we create time dummies here for speed
  *-- note: x SHOULD contain time dummies or constants if you want them
  *-- note: w should be symmetric and positive definite
  *-- these requirements are NOT checked!

  *calculate coefficients
  #delim ;
  mata:
    calc("${MY_tbreaks}",${MY_N},${MY_T},${MY_K_x},${MY_K_z},
         "${MY_xnames}","${MY_yname}","${MY_znames}",
         "`coeffs'","${MY_gmmw}","","");
  #delim cr

  *calculate residuals
  tempvar e
  local substr "${MY_yname}"
  local i=1
  foreach x in $MY_xnames {
    local substr "`substr'-`x'*`coeffs'[1,`i']"
    local i=`i'+1
    }
  qui gen double `e'=`substr'

  *calculate moment conditions
  local momentvars ""
  foreach tt in ${MY_tlist} {
    foreach z in ${MY_znames} {
      tempvar m`z'`tt'
      local momentvars "`momentvars' `m`z'`tt''"
      qui gen double `m`z'`tt''=cond(`t'==`tt',`e'*`z',0)
      }
    tempvar m`tt'
    local momentvars "`momentvars' `m`tt''"
    qui gen double `m`tt''=cond(`t'==`tt',`e',0)
    }

  *compute s
  if "`center'"=="center" local dev "dev"
  else local dev ""
  if "`cluster'"~="" {
    *add up moment conditions within clusters before computing s
    sort `cluster'
    local momentvars2 ""
    foreach v in `momentvars' {
      tempvar `v'2
      *put the sum in every obs even if not part of the sample,
      *but add up only the obs in the sample -- this makes it easier
      *to accumulate vectors by cluster later
      qui by `cluster': egen double ``v'2'=total(`v')
      local momentvars2 "`momentvars2' ``v'2'"
      }
    tempvar clusterlast
    qui by `cluster': gen byte `clusterlast'=(_n==_N)
    local ctag "`momentvars2' if `clusterlast'"
    }
  else {
    *no clustering; regular computation
    local ctag "`momentvars'"
    }
  qui mat accum `s'=`ctag', noconstant `dev'
  matrix `s'=`s'/${MY_N}

  *calculate j
  tempname jw
  mat `jw'=invsym(`s')
  #delim ;
  mata:
    calc("${MY_tbreaks}",${MY_N},${MY_T},${MY_K_x},${MY_K_z},
         "${MY_xnames}","${MY_yname}","${MY_znames}",
         "`coeffs'","${MY_gmmw}","`j'","`jw'");
  #delim cr

  *compute vcv
    *the variance-covariance matrix is the inverse of
    *   inv(G'WG) * G'WSWG * inv(G'WG)
    * where G = d/d(coeffs) sum_i moment_i=Z'X
    *in the efficient case, it is just inv(G'WG/n)
    *note: G has as many rows as there are moment conditions
    *  --  (${MY_K_z}+1)*${MY_T}
    *and as many columns as there are parameters
    *  --  ${MY_K_x}
    * indeed, G=Z'X

  tempname G tempvec
  matrix `G'=J((${MY_K_z}+1)*${MY_T},${MY_K_x},0)
  local K_xp1=${MY_K_x}+1
  forvalues this_t=1(1)${MY_T} {
    local tt : word `this_t' of ${MY_tlist}
    qui mat accum `tempvec'=${MY_xnames} ${MY_znames} if `t'==`tt'
    *by default, last column has a constant, which we included in Z
    *Z'X is rows K_x+1 ... and columns 1..K_x
    local pos=(`this_t'-1)*(${MY_K_z}+1)+1
    mat `G'[`pos',1]=`tempvec'[`K_xp1'...,1..${MY_K_x}]
    }
  mat `vcv'=syminv(`G''*${MY_gmmw}*`G'/${MY_N})
  if "`efficient'"=="" {
    matrix `vcv'=`vcv'*`G''*${MY_gmmw}*`s'*${MY_gmmw}*`G'*`vcv'/${MY_N}
    }

end


version 9.2
mata:
void calc(string scalar tbreaks,
  real scalar N, real scalar T, real scalar Kx, real scalar Kz,
  string xnames, string scalar yname, string znames,
  string scalar coeffs, string scalar w, string scalar j, string scalar jw)
  {

  breaks=st_matrix(tbreaks)

  xtokens=tokens(xnames)
  st_view(xvars,.,xtokens)
  st_view(zvars,.,st_varindex(tokens(znames)))
  st_view(yvar,.,yname)

  Zpy=J((Kz+1)*T,1,0)
  ZpX=J((Kz+1)*T,Kx,0)

  for(t=1;t<=T;t++) {
    pos1=(Kz+1)*(t-1)+1
    pos2=(Kz+1)*t
    zblock=panelsubmatrix(zvars,t,breaks)
    Zpy[|pos1\pos2|]=cross(zblock,1,panelsubmatrix(yvar,t,breaks),0)
    ZpX[|pos1,1\pos2,.|]=cross(zblock,1,panelsubmatrix(xvars,t,breaks),0)
    }

  ww=st_matrix(w)
  ccoeffs=ZpX'*ww
  m2=ccoeffs*ZpX
  ccoeffs=ccoeffs*Zpy
  _lusolve(m2,ccoeffs)
  st_matrix(coeffs,ccoeffs')

  if(j~="") {
    jjw=st_matrix(jw)
    diff=Zpy-ZpX*ccoeffs
    diff=diff'*jjw*diff
    st_numscalar(j,diff[1,1]/N)    
    }

  }
end


