program appa_byid, byable(recall)

version 9.2

syntax, aggvlist(str)

local id1=_byn1()
local id2=_byn2()

local anyerr=0

qui replace keepit=1 in `id1'

foreach v in `aggvlist' {
  quietly {
    if "`v'"=="aggwagesal" local v2="aws"
    else local v2="`v'"
    reg lhly_r l`v'_rpc agecx agecx2 in `id1'/`id2'
    mat b=e(b)
    mat V=e(V)
    replace lev_`v2'_l`v2'_rpc=b[1,1] in `id1'
    replace lev_`v2'_age=b[1,2] in `id1'
    replace lev_`v2'_age2=b[1,3] in `id1'
    replace lev_`v2'_cons=b[1,4] in `id1'
    replace lev_`v2'_se_l`v2'_rpc=sqrt(V[1,1]) in `id1'
    replace lev_`v2'_df=e(df_r) in `id1'
    sum cn_r in `id1'/`id2', meanonly
    local nobs=r(N)
    local nunc=`nobs'-`nobs'*r(mean)
    sum myid2 in `id1', meanonly
    local thisid2=r(min)
    if `nunc'==0 | `thisid2'==121 | `thisid2'==305 {
      *no uncensored observations, or an obs that never converges (stata bug!)
      if `anyerr'==0 global appa_byid_errcount=$appa_byid_errcount+1
      local anyerr=1
      noi di "cnreg for `v' impossible:"
      sum myid in `id1', meanonly
      local thisid=r(min)
      sum myid2 in `id1', meanonly
      local thisid2=r(min)
      noi di "    myid=`thisid', myid2=`thisid2', r(`rc')"
      noi di "    total observations: `nobs'; uncensored: `nunc'"
      }
    else {
      #delim ;
      capture cnreg lhly_r_cn l`v'_rpc agecx agecx2 in `id1'/`id2', 
        censored(cn_r);
      #delim cr
      di "rc = "
      di _rc
      if _rc==0 {
        mat b=e(b)
        mat V=e(V)
        replace cn_`v2'_l`v2'_rpc=b[1,1] in `id1'
        replace cn_`v2'_age=b[1,2] in `id1'
        replace cn_`v2'_age2=b[1,3] in `id1'
        replace cn_`v2'_cons=b[1,4] in `id1'
        replace cn_`v2'_se_l`v2'_rpc=sqrt(V[1,1]) in `id1'
        replace cn_`v2'_df=e(df_r) in `id1'
        replace cn_`v2'_unc=e(N_unc) in `id1'
        }
      else {
        local rc=_rc
        *if no censored observations, can just run regression
        sum cn_r in `id1'/`id2', meanonly
        local nobs=r(N)
        local nunc=`nobs'-`nobs'*r(mean)
        if `nobs'==`nunc' {
          foreach w in l`v2'_rpc age age2 cons se_l`v2'_rpc df {
            replace cn_`v2'_`w'=lev_`v2'_`w' in `id1'
            }
          replace cn_`v2'_unc=`nunc' in `id1'
          }
        else {
          *did not converge and can't be fixed
          if `anyerr'==0 global appa_byid_errcount=$appa_byid_errcount+1
          local anyerr=1
          noi di "cnreg for `v' failed:"
          sum myid in `id1', meanonly
          local thisid=r(min)
          sum myid2 in `id1', meanonly
          local thisid2=r(min)
          noi di "    myid=`thisid', myid2=`thisid2', r(`rc')"
          noi di "    total observations: `nobs'; uncensored: `nunc'"
          }
        }
      }
    reg Dlhly_r Dl`v'_rpc agecx in `id1'/`id2'
    mat b=e(b)
    mat V=e(V)
    replace dif_`v2'_l`v2'_rpc=b[1,1] in `id1'
    replace dif_`v2'_age=b[1,2] in `id1'
    replace dif_`v2'_cons=b[1,3] in `id1'
    replace dif_`v2'_se_l`v2'_rpc=sqrt(V[1,1]) in `id1'
    replace dif_`v2'_df=e(df_r) in `id1'
    }
  }


end



