set more off
clear all
cap log close
log using output/logs/step_5.log, replace
*set mem 1g
*set maxvar 11000

*include do/dofiles/defs.do.h
include "dofiles\defs.do"

*-------------------------------------------------------------------------------
*  FACTOR ESTIMATES à la SW11, INCLUDING BOOTSTRAPPING (WEB APPENDIX TABLE A2.II)
*--------------------------------------------------------------------------------

local nw : word count `sfxlist'

********
dis "`sfxlist'"
dis `nw' 
dis `nsamples'
dis "`typelist'"
dis `nsfx'

*if you wanna set less than 79 bootstrap replications set nsamples..
*local nsamples 4

global tcond ">0"
*********

*foreach type in `typelist' {

  mat resbig=J(4*`nw',`nsamples'+1,.)
  mat resbig_t=J(`nw',`nsamples'+1,.)


  *baseline estimates
  *local idvar seqid_`type'
  *local datafile data/loaded/data_`type'.dta
  local idvar pid
  local datafile data/loaded/data.dta
  
  #delim ;
  factorreg_replic, datafile("data/loaded/data.dta")
      sfxlist(`"`sfxlist'"') idvar(pid) res(res) res_t(res_t);
    *sfxlist(`"`sfxlist'"') idvar(seqid_`type') res(res) res_t(res_t);

  #delim cr
  mat resbig[1,1]=res
  mat resbig_t[1,1]=res_t


  forvalues rep=1(1)`nsamples' {
     #delim ;
	  factorreg_replic, datafile("data/bsamples/data_bs`rep'.dta")
	  sfxlist(`"`sfxlist'"') idvar(newid) res(res) res_t(res_t);
	  *factorreg_replic, datafile("data/bsamples/data_`type'_bs`rep'.dta")
      *sfxlist(`"`sfxlist'"') idvar(pid) res(res) res_t(res_t);

	  
    #delim cr
    local col=`rep'+1
    mat resbig[1,`col']=res
    mat resbig_t[1,`col']=res_t
    drop _all
    }

  local cnames : rownames res
  local cnames_t : rownames res_t
  local cnames2 ""
  local nc : word count `cnames'
  forvalues i=1(1)`nc' {
    local k : word `i' of `cnames'
    local cnames2 "`cnames2' `k'_`i'"
    }
  mat resbig=resbig'
  mat resbig_t=resbig_t'
  mat colnames resbig = `cnames2'
  mat colnames resbig_t = `cnames_t'
  drop _all
  svmat resbig, names(col)
  svmat resbig_t, names(col)
  gen rep=_n+1
  save output/apptable_f2/factorreg_results.dta, replace
  *save output/apptable_f2/factorreg_`type'_results.dta, replace

  
  sum *, sep(0)
  drop _all
  *}
  
clear


*turn the bootstrap results into a table

*foreach type in `typelist' {

  drop _all

  *use output/apptable_f2/factorreg_`type'_results.dta
   use output/apptable_f2/factorreg_results.dta


  *duplicate results
  sum xtivreg*  
  drop xtivreg2_5 xtivreg_need2_7
  rename xtivreg1_1 xtivreg
  rename xtivreg_need1_3 xtivreg_need
  rename factor1_2 factor1
  rename factor_need1_4 factor1_need
  rename factor2_6 factor2
  rename factor_need2_8 factor2_need
  order rep xtivreg factor1 factor2 xtivreg_need factor1_need factor2_need

  replace rep=rep-2

  foreach v in factor1 factor2 factor_tonly {
    foreach sfx in `sfxlist' {
      gen diff`v'`sfx'=`v'`sfx'-xtivreg`sfx'
      }
    }

  foreach var of varlist * {
    if "`var'"~="rep" {
      sum `var' if rep>0 & rep~=.
      scalar m=r(mean)
      gen `var'_bias=m-`var' if rep==0
      gen `var'_bc=2*`var'-m if rep==0
      _pctile `var' if rep>0 & rep~=., percentiles(2.5 5 95 97.5)
      forvalues i=1(1)4 {
        scalar r`i'=r(r`i')
        }
      gen `var'_p025=r1
      gen `var'_p050=r2
      gen `var'_p950=r3
      gen `var'_p975=r4
      gen `var'_ul95=2*`var'-`var'_p025 if rep==0
      gen `var'_ll95=2*`var'-`var'_p975 if rep==0
      gen `var'_ul90=2*`var'-`var'_p050 if rep==0
      gen `var'_ll90=2*`var'-`var'_p950 if rep==0
      }
    }

  sum *, sep(0)

  keep if rep==0

   
  *mat table_`type'=(J(10*`nsfx',4,.)\(0,1,0,1)\(0,0,1,1))
    mat table=(J(10*`nsfx',4,.)\(0,1,0,1)\(0,0,1,1))
  local names "xtivreg factor1 factor_tonly factor2"
  local row1=1
  foreach sfx in `sfxlist' {
    local col=1
    foreach name in `names' {
      *mat table_`type'[`row1',`col']=`name'`sfx'[1]
      *mat table_`type'[`row1'+1,`col']=`name'`sfx'_bc[1]
      *mat table_`type'[`row1'+2,`col']=`name'`sfx'_ll90[1]
      *mat table_`type'[`row1'+3,`col']=`name'`sfx'_ul90[1]
      *mat table_`type'[`row1'+4,`col']=`name'`sfx'_ll95[1]
      *mat table_`type'[`row1'+5,`col']=`name'`sfx'_ul95[1]
	  mat table[`row1',`col']=`name'`sfx'[1]
      mat table[`row1'+1,`col']=`name'`sfx'_bc[1]
      mat table[`row1'+2,`col']=`name'`sfx'_ll90[1]
      mat table[`row1'+3,`col']=`name'`sfx'_ul90[1]
      mat table[`row1'+4,`col']=`name'`sfx'_ll95[1]
      mat table[`row1'+5,`col']=`name'`sfx'_ul95[1]
      if "`name'"~="xtivreg" {
        *mat table_`type'[`row1'+6,`col']=diff`name'`sfx'_ll90[1]
        *mat table_`type'[`row1'+7,`col']=diff`name'`sfx'_ul90[1]
        *mat table_`type'[`row1'+8,`col']=diff`name'`sfx'_ll95[1]
        *mat table_`type'[`row1'+9,`col']=diff`name'`sfx'_ul95[1]
		mat table[`row1'+6,`col']=diff`name'`sfx'_ll90[1]
        mat table[`row1'+7,`col']=diff`name'`sfx'_ul90[1]
        mat table[`row1'+8,`col']=diff`name'`sfx'_ll95[1]
        mat table[`row1'+9,`col']=diff`name'`sfx'_ul95[1]
        }
      local col=`col'+1
      }
    local row1=`row1'+10
    }

  local cnames ""
  foreach n in `names' {
    local cnames "`cnames' `n'_`type'"
    }
  *mat colnames table_`type' = `cnames'
   mat colnames table = `cnames'
  local rnames "coeff biascorrected ci90_ll ci90_ul ci95_ll ci95_ul diffci90_ll diffci90_ul diffci95_ll diffci95_ul"
  local rnames_need ""
  foreach n in `rnames' {
    local rnames_need "`rnames_need' `n'_need"
    }
  *mat rownames table_`type' = `rnames' `rnames_need' riskpref timepref
  mat rownames table = `rnames' `rnames_need' riskpref timepref

  
  di "look here"
  *mat list table_`type'
  mat list table

	
mat table2=table[1..10,1...]
    mat2txt, matrix(table2) saving(output/table_A2_II.txt) replace
		
mat table2eq=table[11...,1...]
    mat2txt, matrix(table2eq) saving(output/table_A2_IIneed.txt) replace
	


*-----------------------------------
*  DONE!
*-----------------------------------

log close
exit
