cap log close
log using output/logs/step_4.log, replace
cd "${path}\shiw\data"

clear matrix
clear all
set more off

*if you wanna use .dta 
use "clean/estimates_shiw", clear 

*if you wanna use csv
*insheet using "clean/estimates_shiw.csv", comma clear


*--------------------------------------------------------------------------
*  PANEL ESTIMATES ON SHIW DATA, (TABLE III,IV,V,VI; WEB APPENDIX TABLE A.I)
*---------------------------------------------------------------------------


bysort pid: egen minwave=min(wave)
 gen spia=minwave==wave
 gen spia2=(spia==1)&(kb1==1|kb2==1)
 bysort pid: egen initcond=max(spia2)
 
 drop spia*
 
 bysort pid: egen wcount=count(wave) if anno>1998
sort pid wave
gen spia = (pid==pid[_n+1] & wave!=(wave[_n+1]-1))
bysort pid: egen scount=sum(spia)
 drop spia
 
 gen primeage=eta>=30 & eta<58  & initcond==1 
 
 sum cn1[aw=peso], d


/*Y = YL + YT + YM + YC*/

*household disposable income
gen y0_h= yl + yt + ym + yc- yca2 -yl2
gen ly0_h = ln(y0_h + 1)

*household labour income
gen yl_h= yl + ym -yl2
gen lyl_h = ln(yl_h + 1)

xtset pid wave
tab wave, gen (w_)
 gen eta2 =eta^2

gen h_leisurea=8760-hoursyear
gen lh_leisurea=ln(h_leisurea)

gen h_leisurea_t=(8760*nperc-hourstot)/nperc
gen lh_leisurea_t=ln(h_leisurea_t)

gen vncomp=(ncomp-l1.ncomp)/(l1.ncomp)
gen vnperc=(nperc-l1.nperc)/(l1.nperc)
gen newretired=qual==6&(l1.qual!=6&l1.qual!=7)
gen newmarried=staciv==1&l1.staciv==2 
gen newsepa=staciv==3&l1.staciv==1 


xtset pid wave
gen vy0_h=(y0_h-l1.y0_h)/((y0_h+l1.y0_h)/2)
gen vyl_h=(yl_h-l1.yl_h)/((yl_h+l1.yl_h)/2)
gen vcn=(cn1-l1.cn1)/((cn1+l1.cn1)/2)

tab anno, gen(y_)
for varlist  *y0_h *yl_h rho c cn1 qual apqual apsett nperc w ncomp nfigli staciv salut disoc godabit istavv : qui gen X_l=l.X 

tab apqual_l, gen(qualif_)
tab apsett_l, gen(settore_)
tab studio , gen(studio)
tab tipolau , gen(tipolau_)
tab tipodip, gen(tipodip_)
gen nonattivo=apqual>=13

tab godabit_l, gen (godab_)
gen owner=godabit==1 & l1.godabit_l
gen tenant=godabit==2 & l1.godabit==2
 
 xtset pid wave
gen ara0= 1/(2.5*(istavv)) if anno==2010
gen ara1= 1/(2.5*(istavv +1)) if anno==2010

gen cn_pro=cn1/(12*ce)

*Building RRA by multiplyng ARA times NONDURABLE CONSUPTIONS (monetary)
replace ytot_i=y_i if anno<2006
gen rra0_c = ara0*cn_pro if anno==2010
*sum ara0 rra0_c [aw=peso], d


/***PANEL ESTIMATES***/
 bysort pid: egen ARA0=min(ara0)
 bysort pid: egen ARA1=min(ara1)
 bysort pid: egen RRA0_c=min(rra0_c)
 
 gen spia=1
 bysort pid: egen nw=sum(spia)
 drop spia
 tab nw
  gen lcn1=ln(cn1)
  
gen C=.
gen Clev=.
forvalues i=1(1)9{
qui sum c if wave==`i' [aw=peso]  
qui ret list
global m`i'=r(mean)
replace C=ln(${m`i'}) if wave==`i'
replace Clev=${m`i'} if wave==`i'

}
bysort wave: sum(C) [aw=peso]
gen Crra0_c=C*RRA0_c
gen Crra=C/RRA0_c
gen Clrra=C*ln(RRA0_c)
 xtset pid wave
gen dCrra=d1.Crra


gen exp=eta-etalav
gen exp2=exp^2
gen married=staciv==1
gen unemp=n_newdisoc>0
gen pageunemp=n_pagedisoc>0


sort pid anno
 bysort pid: gen n=_n if wave==wave[_n-1]+1
 bysort pid: egen min=min(n)
  bysort pid: replace n=min[_n+1]-1 if n[_n+1]==min
  drop nw
sort pid anno
 bysort pid: gen n2=_n if wave==wave[_n-1]+1 & n!=.
 bysort pid: egen nw=max(n2)
 
 gen max_ra=(ARA1!=.&ARA0==.)

 tab sett, gen(sett_)
/*
Settore di attività (se occupato): SETPCF SETMCF
- agricoltura, pesca .............................................................................................. 1 1
- industria ............................................................................................................. 2 2
- pubblica Amministrazione ................................................................................. 3 3
- altri settori (commercio, artigianato, altri servizi, ecc.) ...................................... 4 4
- non risponde/non sa ..........................................................................................
*/
tab qual, gen(qual_)
/*
QUALP7: Occupazione principale, ripartizione per
condizione professionale:
lavoro dipendente:
1 = operaio o posizione similare
2 = impiegato o insegnante
3 = dirigente
lavoro indipendente:
4 = libero professionista
5 = imprenditore
6 = lavoratore in proprio
7= in condizione non professionale (compresi
coadiuvanti)
*/


********************************
/**********income profiles (1)*/
 *********************************
  global cond "eta<59 & eta>24  & nonattivo==0 & wave>1 & nw>=4 & n!=. & ARA1!=. & y0_h >=0"
  global exog "nperc exp married sett_1-sett_4 qual_1-qual_4 "

  set more off

	xtivreg2  ly0_h C Clrra ${exog} if ${cond}  & max_ra!=1 [aw=peso], fe  robust
	est sto gamma_log
	xtivreg2  ly0_h C Crra0_c ${exog} if ${cond}  & max_ra!=1 [aw=peso], fe  robust
	est sto gamma_lev

	  
   
esttab gamma_lev gamma_log, se(4) b(3) /*indicate(controls= )*/ star(* 0.1 ** 0.05 *** 0.01) ///
stats(r2 N N_g g_avg rho, labels("R-squared" "N. of cases" "N. of groups" "Avg n. of T" "frac of var due to u_i")) legend ///
varlabels(_cons Constant) posthead("") prefoot("") postfoot("") varwidth(16) style(fixed)


*****************************************************************
*Table A.I (Web Appendix): 
*ARA (left panel) and RRA (right panel) unconditional distributions	 
********************************************************************
gen ara=ara0
gen rra=rra0_c
sum ara rra [aw=peso], d
estpost sum ara rra [aw=peso], d
  cd "${path}/shiw/output"
esttab using table_A_I, replace cells("count mean Var sd min max p1 p5 p10 p25 p50 p75 p90 p95 p99 skewness kurtosis") noobs
  drop ara rra
  cd "${path}/shiw/data"


/*BREAK DOWN TABLE OF MAIN VARIABLES BY RISK TOLERANCE GROUP*/
/*
 xtile wealth3rd = w [aw=peso] if anno==2010,  nq(3)
 xtile totinc3rd = y [aw=peso] if anno==2010,  nq(3)
 xtile finwealth3rd = af [aw=peso] if anno==2010,  nq(3)
 xtile riskfinwealth3rd = af3 [aw=peso] if anno==2010,  nq(3)
 gen ara=ara0 
 gen rra=rra0_c

tabstat ara rra if anno==2010 [aw=peso], by(sex) stats(mean median N)
tabstat ara rra if anno==2010 [aw=peso], by(area3) stats(mean median N)
tabstat ara rra if anno==2010 [aw=peso], by(cleta) stats(mean median N)
tabstat ara rra if anno==2010 [aw=peso], by(staciv) stats(mean median N)
tabstat ara rra if anno==2010 [aw=peso], by(nperc) stats(mean median N)
tabstat ara rra if anno==2010 [aw=peso], by(godabit) stats(mean median N)
tabstat ara rra if anno==2010 [aw=peso], by(laurea) stats(mean median N)
tabstat ara rra if anno==2010 [aw=peso], by(wealth3rd) stats(mean median N)
tabstat ara rra if anno==2010 [aw=peso], by(totinc3rd) stats(mean median N)
tabstat ara rra if anno==2010 [aw=peso], by(finwealth3rd) stats(mean median N)
tabstat ara rra if anno==2010 [aw=peso], by(riskfinwealth3rd) stats(mean median N)
tabstat ara rra if anno==2010 [aw=peso], by(carta) stats(mean median N)
tabstat ara rra if anno==2010 [aw=peso], by(varred) stats(mean median N)
tabstat ara rra if anno==2010 [aw=peso], by(qual) stats(mean median N)
tabstat ara rra if anno==2010 [aw=peso], by(carta) stats(mean median N)
*/

 *Generate time dummies to proxy Lagrange multiplier
  gen risktol=RRA0_c^-1
 tab wave, gen (t_)
 forvalues i=2(1)8{
gen t_`i'r = t_`i'*risktol
}

**************************************************************************************
**Risk tolerance and the relationship between income and idiosyncratic risk (table IV)
**************************************************************************************

*Table IV: 
*Endogeneity analysis of RRA w.r.t the household income process
preserve
cd "${path}\shiw"
do _step_4b.do
restore
cd "${path}/shiw/data"
**************************************



********************************************
/***2nd STEP: Risk sharing regressions****/
********************************************


********************************************
*********************IN LEVELS**************
********************************************
   
   global exog "eta eta2 nfigli03  ncomp married tenant" 
   global cond "primeage & nw>=3 & n!=. &  y0_h >=0"


  sum lcn1 ly0_h unemp newdisoc ${exog} Crra0_c risktol  if ${cond} 

 xtreg lcn1 ly0_h  ${exog} Crra if ${cond}, fe
 xtivreg2 lcn1 ly0_h  ${exog} Crra if ${cond} [aw=peso], fe robust
 xi: xtivreg2 lcn1 ly0_h  ${exog} t_2r-t_8r  if ${cond} [aw=peso], fe robust
 est sto fe_rra
 
 xtreg lcn1 ly0_h  ${exog} C if e(sample), fe
 xtivreg2 lcn1 ly0_h  ${exog} C if e(sample) [aw=peso], fe robust
 xi: xtivreg2 lcn1 ly0_h  ${exog} i.wave if e(sample) [aw=peso], fe robust
 est sto fe

 
  gen hoursoth=hourstot-hoursyear
  global cond "primeage & nw>=3 & n!=. &  y0_h >=0 "
 xi: xtivreg2 lcn1  eta eta2 ncomp nfigli03 married tenant t_2r-t_8r (ly0_h = n_pagedisoc  lh_leisurea) [aw = peso] if ${cond} , endog(ly0_h) fe  first ffirst savefirst robust
 est sto xtiv_rra
 xi: xtivreg2 lcn1  eta eta2 ncomp nfigli03 married tenant i.wave /*w_9*/ (ly0_h = n_pagedisoc  lh_leisurea) [aw = peso] if e(sample) , endog(ly0_h) fe  first ffirst savefirst robust
 est sto xtiv


 **********************************
 ******IN DIFFERENCES**************
 **********************************
 
 global cond "eta<57 & eta>24  & nonattivo==0 & nw>=3 & n!=. & scount==0 & anno>1998 &  y0_h >=0 "
 
 xi: ivreg2 vcn vy0_h eta vncomp  t_2r-t_8r [aw = peso] if ${cond},  robust 
  est sto dxt_rra
 
 xi: ivreg2 vcn eta vncomp  t_2r-t_8r (vy0_h =n_pagedisoc d.lh_leisurea) [aw = peso] if ${cond} , endog(vy0_h) first ffirst savefirst robust gmm2s
  est sto dxtiv_rra
 
 xi: ivreg2 vcn vy0_h eta vncomp  i.wave [aw = peso] if ${cond} & e(sample),  robust 
 est sto dxt

 xi: ivreg2 vcn eta vncomp i.wave (vy0_h = n_pagedisoc d.lh_leisurea) [aw = peso] if ${cond} & e(sample) , endog(vy0_h) first ffirst savefirst robust gmm2s
 est sto dxtiv
 
  cd "${path}/shiw/output"
 ***************************************
/*************table III*******************/ 
 ***************************************
 esttab gamma_log using table_III.txt, replace se(4) b(3) star(* 0.1 ** 0.05 *** 0.01) ///
stats(r2 N N_g g_avg rho, labels("R-squared" "N. of cases" "N. of groups" "Avg n. of T" "frac of var due to u_i")) legend ///
varlabels(_cons Constant) posthead("") prefoot("") postfoot("") varwidth(16) style(fixed)
 
 ***************************************
/*************table V*******************/ 
 ***************************************
esttab fe fe_rra xtiv xtiv_rra  using table_V.txt, replace se(4) b(3) indicate(controls= eta* ncomp nfigli03  married tenant) star(* 0.1 ** 0.05 *** 0.01) ///
stats(r2 N N_g g_avg rho ar1p cdf sarganp jp hansenp  estatp, labels("R-squared" "N. of cases" "N. of groups" "Avg n. of T" "frac of var due to u_i" "A.-Bond test AR(1) p value" "Cragg-Donald Wald F" "Sargan p value" "Hansen J p value" "Hansen J p value" "Endogeneity test p-val")) legend ///
varlabels(_cons Constant) posthead("") prefoot("") postfoot("") varwidth(16) style(fixed)
 
 ***************************************
/*************table VI******************/ 
 *************************************** 
esttab dxt dxt_rra dxtiv dxtiv_rra using table_VI.txt, replace se(4) b(3) indicate(controls=eta vncomp ) star(* 0.1 ** 0.05 *** 0.01) ///
stats(r2 N N_g g_avg rho ar1p cdf sarganp jp hansenp  estatp, labels("R-squared" "N. of cases" "N. of groups" "Avg n. of T" "frac of var due to u_i" "A.-Bond test AR(1) p value" "Cragg-Donald Wald F" "Sargan p value" "Hansen J p value" "Hansen J p value" "Endogeneity test p-val")) legend ///
varlabels(_cons Constant) posthead("") prefoot("") postfoot("") varwidth(16) style(fixed)

cd "${path}/shiw"

 
*DONE!
