program gmm_s2, sortpreserve
  version 9.2

  #delim ;
  syntax, d(name) s(name) t(varname)
    [cluster(varname) center vcv(name) efficient useoffset(integer 0)
     mbar(name)];
  #delim cr
  *d: quasi-differencing vector
  *s: variance-covariance matrix of moment conditions is returned here
  *vcv: variance-covariance matrix of estimator -- both d and the
  *  coefficients computed internally -- is returned here
  *efficient: weighting matrix is known to be efficient; use simplified 
  *  calculation.
  *mbar: mean of moment conditions is returned here as row vector (for
  *  offsetting subsequent bootstrap estimates)

  *compute estimator
  gmm_compute, b(`d') useoffset(`useoffset')

  *create quasi-differenced variables
  local condstr "."
  forvalues tt=1(1)$MY_T {
    local ttn : word `tt' of $MY_tlist
    local condstr "cond(`t'==`ttn',`d'[1,`tt'],`condstr')"
    }
  tempvar dtemp
  qui gen double `dtemp'=`condstr'
  foreach v in $MY_xnames $MY_yname {
    tempname del`v'
    qui gen double `del`v''=`v'-`dtemp'*L`v'
    }
  local my_xvars ""
  foreach v in $MY_xnames {
    local my_xvars "`my_xvars' `del`v''"
    }

  *calculate residuals
  tempvar e
  local substr "`del${MY_yname}'"
  local i=1
  foreach x in $MY_xnames {
    local substr "`substr'-`del`x''*${MY_gmmcoeffs}[1,`i']"
    local i=`i'+1
    }
  qui gen double `e'=`substr'

  *calculate moment conditions
  local momentvars ""
  foreach tt in ${MY_tlist} {
    foreach z in ${MY_znames} {
      tempvar m`z'`tt'
      local momentvars "`momentvars' `m`z'`tt''"
      qui gen double `m`z'`tt''=cond(`t'==`tt',`e'*`z',0)  
      }
    tempvar m`tt'
    local momentvars "`momentvars' `m`tt''"
    qui gen double `m`tt''=cond(`t'==`tt',`e',0)
    }

  *compute s
  if "`center'"=="center" local dev "dev"
  else local dev ""
  if "`cluster'"~="" {
    *add up moment conditions within clusters before computing s
    sort `cluster'
    local momentvars2 ""
    foreach v in `momentvars' {
      tempvar `v'2
      *put the sum in every obs even if not part of the sample,
      *but add up only the obs in the sample -- this makes it easier
      *to accumulate vectors by cluster later
      qui by `cluster': egen double ``v'2'=total(`v')
      local momentvars2 "`momentvars2' ``v'2'"
      }
    tempvar clusterlast
    qui by `cluster': gen byte `clusterlast'=(_n==_N)
    local ctag "`momentvars2' if `clusterlast'"
    }
  else {
    *no clustering; regular computation
    local ctag "`momentvars'"
    }
  qui mat accum `s'=`ctag', noconstant `dev'
  *offset matters only if we compute uncentered s
  if "`center'"=="" & `useoffset' {
    *sum_i (m_i-v)(m_i-v)' = sum_i m_i*m_i' - v*sum_i m_i' -(sum_i m_i)*v' + N*v*v'
    tempname vv
    qui mat accum `vv'=`ctag'
    *sums are now in last column
    local r=colsof(`vv')
    local rm1=`r'-1
    mat `vv'=`vv'[1..`rm1',`r']
    mat `vv'=`vv'*${MY_gmmoffset}
    mat `s'=`s'-`vv'-`vv''+${MY_N}*${MY_gmmoffset}'*${MY_gmmoffset}
    }
  matrix `s'=`s'/${MY_N}

  *compute mbar if desired
  if "`mbar'"~="" {
    qui mat accum `mbar'=`ctag'
    *sums are now in last row
    local r=colsof(`mbar')
    local rm1=`r'-1
    mat `mbar'=`mbar'[`r',1..`rm1']/${MY_N}
    }

  *compute vcv if desired
  if "`vcv'"~="" {

    *the variance-covariance matrix is the inverse of
    *   inv(G'WG) * G'WSWG * inv(G'WG)
    * where G = d/d(coeffs) sum_i moment_i
    *in the efficient case, it is just inv(G'WG/n)
    *note that offset does not affect G

    *note: G has as many rows as there are moment conditions 
    *  --  (${MY_K_z}+1)*${MY_T}
    *and as many columns as there are parameters
    *  --  ${MY_T}+${MY_K_x}

    *the quasidifferencing variables:
    *we want d/db Z'(dely - delX * beta), where dely = y_t - d_t*y_t-1,
    *so the derivative wrt d_t is -Z'(y_t-1 - X_t-1 beta)
    *and derivative of moment conditions at t wrt d_s for s~=t is 0
    *everything else: G=Z'delX

    *thus we can divide G into two sets of columns:
    * -- set one (columns 1 to MY_T):   -Z'(Ly - Lx * beta)
    * -- set two (columns MY_T+1 to MY_T+MY_K_x) : Z'delX
    *and MY_T sets of rows
    * -- each set is the elements for date t

    tempname G tempvec
    tempvar u
    local ustr L${MY_yname}
    foreach v in `my_xnames' {
      local ustr "`ustr'-L`v'"
      }
    qui gen double `u'=`ustr'
    matrix `G'=J((${MY_K_z}+1)*${MY_T},${MY_T}+${MY_K_x},0)
    local K_xp1=${MY_K_x}+1
    local K_xp2=${MY_K_x}+2
    local Tp1=${MY_T}+1
    forvalues this_t=1(1)${MY_T} {
      local tt : word `this_t' of ${MY_tlist}
      qui mat accum `tempvec' = `u' `my_xvars' ${MY_znames} if `t'==`tt'
      *by default, last column has a constant
      * Z'u is first column, elements K_x+2..{K_x+K_z+3}, and gets stored 
      * on the block diagonal of U'Z
      local pos=(`this_t'-1)*(${MY_K_z}+1)+1
      matrix `G'[`pos',`this_t']=-`tempvec'[`K_xp2'...,1]
      * Z'X is rows K_x+2..K_x+K_z+3 and columns 2..K_x+1
      matrix `G'[`pos',`Tp1']=`tempvec'[`K_xp2'...,2..`K_xp1']
      }

    matrix `vcv'=syminv(`G''*${MY_gmmw}*`G'/${MY_N})
    if "`efficient'"=="" {
      matrix `vcv'=`vcv'*`G''*${MY_gmmw}*`s'*${MY_gmmw}*`G'*`vcv'/${MY_N}
      }

    *end of vcv block
    }

end

