program factorreg_setup_iv
version 10.1

  *warning: this trashes the data
  *use preserve first

  syntax varlist [if] [in], i(varname) t(varname) rpfx(string) f(name) added(name)

  *we construct R_i = M_i - M_i * F_i * inv(F_i'*M_i*F_i) * F_i'*M_i
  *where M_i= I_i - iota_i * iota_i' / T_i
  *F is T x K_f

  marksample touse
  markout `touse' `t'
  markout `touse' `i', strok
  qui keep if `touse'

  tempname tvals
  qui tab `t', matrow(`tvals')
  global MY_T_IV=rowsof(`tvals')
  local iotalist ""
  global MY_R_IV ""
  local condstr "."
  forvalues tt=1(1)$MY_T_IV {
    tempvar iota`tt'
    qui gen byte `iota`tt''=(`t'==`tvals'[`tt',1])
    local iotalist "`iotalist' `iota`tt''"
    qui gen double `rpfx'`tt'=0
    global MY_R_IV "$MY_R_IV `rpfx'`tt'"
    local condstr "cond(`t'==`tvals'[`tt',1],`tt',`condstr')"
    }
  tempvar tnew
  qui gen `tnew'=`condstr'
  qui tsset `i' `tnew'
  qui gen byte `added'=0
  qui tsfill, full
  qui replace `added'=1 if `added'==.
  foreach var in `varlist' `iotalist' {
    qui replace `var'=0 if `added'
    }

  mata: fsetup("$MY_IV_ibreaks","`i'","`f'","`iotalist'","$MY_R_IV")
  global MY_N_IV=rowsof($MY_IV_ibreaks)

  tsset, clear

end


version 10.1
mata:
void fsetup(string scalar breaks, string scalar i, string scalar f,
  string iotalist, string Rlist)
  {

  st_view(id,.,i)
  bbreaks=panelsetup(id,1)
  st_matrix(breaks,bbreaks)
  N=rows(bbreaks)

  ff=st_matrix(f)

  st_view(iota,.,st_varindex(tokens(iotalist)))
  st_view(R,.,st_varindex(tokens(Rlist)))

  /* we construct R_i = M_i - M_i * F_i * inv(F_i'*M_i*F_i) * F_i'*M_i
   where M_i= I_i - iota_i * iota_i' / T_i.
   note that M_i * F = F_i, so
   R_i = M_i - M_i * F * inv(F'*M_i*F) * F'*M_i */

  for(ii=1;ii<=N;ii++)
    {
    p1=bbreaks[ii,1]
    p2=bbreaks[ii,2]
    Mi=panelsubmatrix(iota,ii,bbreaks)
    Md=diagonal(Mi)
    Mi=Mi-Md*Md'/(Md'*Md)
    /* generalized inverse in case F happens to be collinear */
    R[|p1,1\p2,.|]=Mi-Mi*ff*invsym(ff'*Mi*ff)*ff'*Mi
    }
  }
end
