program factorreg_setup
version 10.1

  *warning: this trashes the data
  *use preserve first

  #delim ;
  syntax varlist [if] [in],
    i(name) t(name) rpfx(string) f(name)
    added(name);
  #delim cr

  *we construct R_i = M_i - M_i * F_i * inv(F_i'*M_i*F_i) * F_i'*M_i
  *where M_i= I_i - iota_i * iota_i' / T_i
  *F is T x K_f

  marksample touse
  markout `touse' `i' `t'
  qui keep if `touse'
  tempname tvals
  qui tab `t', matrow(`tvals')
  global MY_T=rowsof(`tvals')
  local iotalist ""
  global MY_R ""
  local condstr "."
  forvalues tt=1(1)$MY_T {
    tempvar iota`tt'
    qui gen byte `iota`tt''=(`t'==`tvals'[`tt',1])
    local iotalist "`iotalist' `iota`tt''"
    qui gen double `rpfx'`tt'=0
    global MY_R "$MY_R `rpfx'`tt'"
    local condstr "cond(`t'==`tvals'[`tt',1],`tt',`condstr')"
    }
  tempvar tnew
  qui gen `tnew'=`condstr'

  local nx : word count `varlist'
  local nx=`nx'-1
  if `nx'>0 {
    global MY_Rx ""
    forvalues xx=1(1)`nx' {
      qui gen double `rpfx'x`xx'=0
      global MY_Rx "$MY_Rx `rpfx'x`xx'"
      }
    }
  qui gen double `rpfx'y=0
  global MY_Ry "`rpfx'y"
  global MY_yRRy "`rpfx'yRRy"
  global MY_XRRX "`rpfx'XRRX"
  global MY_yRRX "`rpfx'yRRX"

  qui tsset `i' `tnew'
  qui gen byte `added'=0
  qui tsfill, full
  qui replace `added'=1 if `added'==.
  foreach var in `varlist' `iotalist' {
    qui replace `var'=0 if `added'
    }

  gettoken y x : varlist
  mata: fsetup("$MY_ibreaks","`i'","`f'","`iotalist'","$MY_R","$MY_Ry","$MY_yRRy","$MY_Rx","$MY_XRRX","$MY_yRRX",`nx',"`y'","`x'")
  global MY_N=rowsof($MY_ibreaks)

  tsset, clear

end


version 10.1
mata:
void fsetup(string scalar breaks, string scalar i, string scalar f,
  string iotalist, string Rlist, string scalar Ry, string scalar yRRy,
  string RX, string scalar XRRX, string scalar yRRX,
  real scalar Kx, string scalar y, string scalar X)
  {

  st_view(id,.,i)
  bbreaks=panelsetup(id,1)
  st_matrix(breaks,bbreaks)
  N=rows(bbreaks)

  ff=st_matrix(f)

  st_view(iota,.,st_varindex(tokens(iotalist)))
  st_view(R,.,st_varindex(tokens(Rlist)))
  st_view(RRy,.,Ry)
  st_view(yy,.,y)
  if(Kx>0) {
    st_view(RRX,.,st_varindex(tokens(RX)))
    st_view(XX,.,st_varindex(tokens(X)))
    }

  /* we construct R_i = M_i - M_i * F_i * inv(F_i'*M_i*F_i) * F_i'*M_i
   where M_i= I_i - iota_i * iota_i' / T_i.
   note that M_i * F = F_i, so
   R_i = M_i - M_i * F * inv(F'*M_i*F) * F'*M_i */
  /* we also construct R_i*X_i and R_i*y_i */
  /* yRRy=sum_i y_i'R_i'R_i*y_i */

  yyRRy=0
  if(Kx>0) {
    yyRRX=J(1,Kx,0)
    XXRRX=J(Kx,Kx,0)
    }
  for(ii=1;ii<=N;ii++)
    {
    p1=bbreaks[ii,1]
    p2=bbreaks[ii,2]
    Mi=panelsubmatrix(iota,ii,bbreaks)
    Md=diagonal(Mi)
    Mi=Mi-Md*Md'/(Md'*Md)
    /* generalized inverse in case F happens to be collinear */
    R[|p1,1\p2,.|]=Mi-Mi*ff*invsym(ff'*Mi*ff)*ff'*Mi
    RRy[|p1\p2|]=R[|p1,1\p2,.|]*yy[|p1\p2|]
    yyRRy=yyRRy+RRy[|p1\p2|]'*RRy[|p1\p2|]
    if(Kx>0) {
      RRX[|p1,1\p2,.|]=R[|p1,1\p2,.|]*XX[|p1,1\p2,.|]
      yyRRX=yyRRX+RRy[|p1\p2|]'*RRX[|p1,1\p2,.|]
      XXRRX=XXRRX+RRX[|p1,1\p2,.|]'*RRX[|p1,1\p2,.|]
      }
    }
  st_numscalar(yRRy,yyRRy)
  if(Kx>0) {
    st_matrix(XRRX,XXRRX)
    st_matrix(yRRX,yyRRX)
    }
  }
end
