set more off
clear all
cap log close
log using output/logs/step3a.log, replace
version 10.1
*set mem 1g
set maxvar 11000

include dofiles/defs.do.h

dis "`sfxlist'"
dis `nw' 
dis `nsamples'
*local typelist "omemb"
dis "`typelist'"
dis `nsfx' 

global tcond ">=1 & t<=24"

*----------------------------------------
*  GMM ESTIMATES (TABLE III, columns 1-4)
*----------------------------------------

local ilist "lh_leisurea l1lh_leisurea"

local foodvars ""
foreach sfx in `sfxlist' {
  local foodvars "`foodvars' lfood_real`sfx'"
  }
di `"`foodvars'"'

local incvars ""
foreach sfx in `sfxlist' {
  local incvars "`incvars' lnetfmy_real`sfx'"
  }
di `"`incvars'"'

local ikeep ""
local ni : word count `ilist'
forvalues i=1(1)`ni' {
  local inst : word `i' of `ilist'
  if `i'==1 local ikeep="(`inst'~=."
  else if `i'==`ni' local ikeep="`ikeep' & `inst'~=.)"
  else local ikeep "`ikeep' & `inst'~=."
  }
di "`ikeep'"

tempfile gmm_temp

foreach type in `typelist' {

  if "`type'"=="hw" local output "apptable_f3/apptable_f3"
	else local output "apptable_f4/apptable_f4"

  *load data and set up
  gmm_doit, cmd("use data/loaded/data_`type'.dta")
  gen t=datayear-1972
  *****************
  tab t
  keep if t $tcond
  tab t
  gen spia=1
  bysort headpid: egen nwave=sum(spia)
  keep if nwave>=4
  tab nwave
  drop spia nwave
  tsset headpid t
gen dy=d.lnetfmy_real
  bys t: sum lnetfmy_real dy
  sum dy
  drop dy
  *****************
  tsset seqid_`type' t
  foreach v in `foodvars' `incvars' lh_leisurea {
    qui gen d2`v'=D2.`v'
    qui gen del3`v'=`v'-L3.`v'
    qui gen del2`v'=`v'-L2.`v'
    qui gen deldel2`v'=del2`v'-L.del2`v'
    forvalues l=1(1)3 {
      qui gen l`l'`v'=L`l'.`v'
      }
    }
	

  xi i.t, prefix(_T) noomit
  local tdel3 ""
  local tdeldel2 ""
  local food1 : word 1 of `foodvars'
  foreach v of varlist _T* {
    qui count if del3`food1'~=. & `v'==1 & `ikeep'
    if r(N)>0 local tdel3 "`tdel3' `v'"
    qui count if deldel2`food1'~=. & `v'==1 & `ikeep'
    if r(N)>0 local tdeldel2 "`tdeldel2' `v'"
    }
  di "`tdel3'"
  di "`tdeldel2'"

  *to avoid preserve/restore
  compress
  save `gmm_temp', replace

  *calculate

  foreach sfx in `sfxlist' {

		di _newline _newline _newline
		di "-------------"
		di _newline
		di "starting ..."
		di "data: `type'"
		di "sfx: `sfx'"

		matrix results_`type'_`sfx'=J(9,8,.)

		*turn off offset
		global MY_gmmoffset ""
		global MY_gmmuseoffset=0

		#delim ;
		collapse (count) n1=del3lnetfmy_real`sfx' n2=del3lfood_real,
			by(orig_psu) fast;
		#delim cr
		di "clusters:"
		count if n1>0 & n1~=. & n2>0 & n2~=.
		global clusters=r(N)
		drop _all
		use `gmm_temp'

		local cnames ""

		*first differences, w/o leisure on rhs
		#delim ;
		gmm_doit, cmd(`"gmm_estimate_timeseparate,
			x(del3lnetfmy_real`sfx' `tdel3') y(del3lfood_real`sfx') z(`ilist')
			i(seqid_`type') t(t) cluster(orig_psu) center"');
		#delim cr
		gmm_showres
		gmm_captureit, matrix(myres) timeseparate
		matrix results_`type'_`sfx'[1,1]=myres
		drop _all
		use `gmm_temp'
		local cnames "`cnames' nohet"

		*first differences, w/ leisure on rhs
		#delim ;
		gmm_doit, cmd(`"gmm_estimate_timeseparate,
			x(del3lnetfmy_real`sfx' del3lh_leisurea `tdel3') y(del3lfood_real`sfx')
			z(`ilist')
			i(seqid_`type') t(t) cluster(orig_psu) center"');
		#delim cr
		gmm_showres
		gmm_captureit, matrix(myres) hasleisure timeseparate
		matrix results_`type'_`sfx'[1,2]=myres
		drop _all
		use `gmm_temp'
		local cnames "`cnames' nohet_leis"

		*second differences, w/o leisure on rhs
		#delim ;
		gmm_doit, cmd(`"gmm_estimate_timeseparate,
			x(deldel2lnetfmy_real`sfx' `tdeldel2')
			y(deldel2lfood_real`sfx') z(`ilist')
			i(seqid_`type') t(t) cluster(orig_psu) center"');
		#delim cr
		gmm_showres
		gmm_captureit, matrix(myres) timeseparate
		matrix results_`type'_`sfx'[1,3]=myres
		drop _all
		use `gmm_temp'
		local cnames "`cnames' time"

		*second differences, w/ leisure on rhs
		#delim ;
		gmm_doit, cmd(`"gmm_estimate_timeseparate,
			x(deldel2lnetfmy_real`sfx' deldel2lh_leisurea `tdeldel2')
			y(deldel2lfood_real`sfx') z(`ilist')
			i(seqid_`type') t(t) cluster(orig_psu) center"');
		#delim cr
		gmm_showres
		gmm_captureit, matrix(myres) hasleisure timeseparate
		matrix results_`type'_`sfx'[1,4]=myres
		drop _all
		use `gmm_temp'
		local cnames "`cnames' time_leis"

		*first differences and time-varying indiv effect, w/o leisure on rhs
		#delim ;
		gmm_doit, cmd(`"gmm_estimate, x(del2lnetfmy_real`sfx')
			y(del2lfood_real`sfx') z(`ilist')
			i(seqid_`type') t(t) cluster(orig_psu) center"');
		#delim cr
		gmm_showres
		gmm_captureit, matrix(myres)
		matrix results_`type'_`sfx'[1,5]=myres
		drop _all
		use `gmm_temp'
		local cnames "`cnames' risk"

		*first differences and time-varying indiv effect, w/ leisure on rhs
		#delim ;
		gmm_doit, cmd(`"gmm_estimate, x(del2lnetfmy_real`sfx' del2lh_leisurea)
			y(del2lfood_real`sfx') z(`ilist')
			i(seqid_`type') t(t) cluster(orig_psu) center"');
		#delim cr
		gmm_showres
		gmm_captureit, matrix(myres) hasleisure
		matrix results_`type'_`sfx'[1,6]=myres
		drop _all
		use `gmm_temp'
		local cnames "`cnames' risk_leis"

		*second differences and time-varying indiv effect, w/o leisure on rhs
		#delim ;
		gmm_doit, cmd(`"gmm_estimate, x(d2lnetfmy_real`sfx')
			y(d2lfood_real`sfx') z(`ilist')
			i(seqid_`type') t(t) cluster(orig_psu) center"');
		#delim cr
		gmm_showres
		gmm_captureit, matrix(myres)
		matrix results_`type'_`sfx'[1,7]=myres
		drop _all
		use `gmm_temp'
		local cnames "`cnames' timerisk"

		*second differences and time-varying indiv effect, w/ leisure on rhs
		#delim ;
		gmm_doit, cmd(`"gmm_estimate, x(d2lnetfmy_real`sfx' d2lh_leisurea)
			y(d2lfood_real`sfx') z(`ilist')
			i(seqid_`type') t(t) cluster(orig_psu) center"');
		#delim cr
		gmm_showres
		gmm_captureit, matrix(myres) hasleisure
		matrix results_`type'_`sfx'[1,8]=myres
		drop _all
		use `gmm_temp'
		local cnames "`cnames' timerisk_leis"

		local rnames : rownames myres
		mat rownames results_`type'_`sfx' = `rnames'
		mat colnames results_`type'_`sfx' = `cnames'
		#delim ;
		mat2txt, matrix(results_`type'_`sfx') 
			saving(output/`output'_results_`type'_`sfx') replace;
		#delim cr
		
		*table 3: omemb, adult equivalents
		if "`type'"=="omemb" & "`sfx'"=="_need" {
		  mat2txt, matrix(results_`type'_`sfx') saving(output/table_II/table_II_cols14_`type'_`sfx') replace
		  }

		di "data: `type'"
		di "sfx: `sfx'"
		di "... done"
		di _newline
		di "-------------"
		di _newline _newline _newline

    *end of loop over hh size adjustment
    }
  
  *end of loop over hw/omemb
  drop _all
  }


*-----------------------------------
*  DONE!
*-----------------------------------

log close
exit
