clear all

local location "C:\Users\spyro\OneDrive - Lancaster University\Submitted_papers_Replication_files\Risk_UK_JAE_Feb_2021" 

**********************************************************************************************************************
**********************************************************************************************************************
**********************************************************************************************************************
*****************                      5. Household Annual Total Earnings                        *********************
**********************************************************************************************************************
**********************************************************************************************************************
**********************************************************************************************************************
**********************************************************************************************************************
use "`location'\\data\paneldataBHPS_UK.dta", clear

******************************************************************
*******               E1. sample selection                 *******
******************************************************************
keep if memorig==1
drop if ivfho==11 | ivfho==12
d, s
sort pid year

gen  jbrgsc_h_aux = jbrgsc if hoh_ind >0
egen jbrgsc_h     = max(jbrgsc_h), by(hid year)
drop if jbrgsc_h==7
drop if region==12
gen  region_h_aux = region if hoh_ind >0
egen region_h     = min(region_h_aux), by(hid year)
drop if region_h<0

drop if numads>= . | numhhkid>= . 

drop if mastat<0

replace YE_main=annual_earn
replace YE_main= .  if YE_main<0

gen  YE_h_aux = YE_main if hoh_ind > 0
egen YE_h     = max(YE_h_aux), by(hid year)

drop if YE_h >= . | YE_h<threshold

keep if hoh_ind>0
drop if age < 23 | age > 62
drop if educ_h>5

gen dum_ed=2
replace dum_ed=1 if qfedhi==1 | qfedhi==2
 

gen lYE_main  = log(YE_main)
gen lYE_h     = log(YE_h)

* Household demographic regressor
gen lnumhh = log(numads + numhhkid)
gen lnumads = log(numads)
gen lnumhhkid = log(numhhkid)


gen Y_Lab=hhyrlg+hhyrt
drop if Y_Lab==0
drop if Y_Lab>= . | Y_Lab<threshold

gen Y  =hhyrlg+hhyrt
gen Y_b=Y+hhyrb
gen Y_n=hhyrln+hhyrt+yrcontr
gen Y_t=hhyrln+hhyrt+hhyrb+yrcontr
gen Y_p=hhyrln+hhyrt+hhyrb
gen Y_D=hhyneti+yrcontr

gen lY_Lab  = log(Y_Lab)
gen lY  = log(Y)
gen lY_p  = log(Y_p)
gen lY_b  = log(Y_b)
gen lY_n  = log(Y_n)
gen lY_t  = log(Y_t)
gen lY_D  = log(Y_D)

drop hh_weights numads

*******************************************************************
******* E3. for the partialing out exercise, we keep       *******
******* only those who participate in the generation       *******
******* of growth rates                                    *******
******************************************************************

keep pid year hid hoh_ind hoh sex age dum_ed  region lnumhh lnumads lnumhhkid mastat educ_att Y_Lab lY_Lab Y Y_b Y_t Y_n Y_p Y_D lY lY_p lY_b lY_t lY_n lY_D YE_main lYE_main

reshape wide hid hoh_ind hoh sex age dum_ed  region lnumhh lnumads lnumhhkid mastat educ_att Y_Lab lY_Lab Y Y_b Y_t Y_n Y_p Y_D lY lY_p lY_b lY_t lY_n lY_D YE_main lYE_main, i(pid) j(year)
reshape long hid hoh_ind hoh sex age dum_ed  region lnumhh lnumads lnumhhkid mastat educ_att Y_Lab lY_Lab Y Y_b Y_t Y_n Y_p Y_D lY lY_p lY_b lY_t lY_n lY_D YE_main lYE_main, i(pid) j(year)

gen index1=0 
replace index1=1 if lY_Lab[_n+1]!= . & lY_Lab[_n]  != . & lY_Lab[_n-1]!= .  & pid[_n+1] ==pid[_n-1] & dum_ed[_n+1] ==dum_ed[_n-1] 
replace index1=1 if lY_Lab[_n]  != . & lY_Lab[_n-1]!= . & lY_Lab[_n-2]!= .  & pid[_n] ==pid[_n-2]   & dum_ed[_n]   ==dum_ed[_n-2]
replace index1=1 if lY_Lab[_n+2]!= . & lY_Lab[_n+1]!= . & lY_Lab[_n]  != .  & pid[_n+2] ==pid[_n]   & dum_ed[_n+2] ==dum_ed[_n] 
keep if index1==1
drop index1

reshape wide hid hoh_ind hoh sex age dum_ed  region lnumhh lnumads lnumhhkid mastat educ_att Y_Lab lY_Lab Y Y_b Y_t Y_n Y_p Y_D lY lY_p lY_b lY_t lY_n lY_D YE_main lYE_main, i(pid) j(year)
reshape long hid hoh_ind hoh sex age dum_ed  region lnumhh lnumads lnumhhkid mastat educ_att Y_Lab lY_Lab Y Y_b Y_t Y_n Y_p Y_D lY lY_p lY_b lY_t lY_n lY_D YE_main lYE_main, i(pid) j(year)

******************************************************************
*******              E4. Creation of dummies               *******
******************************************************************
qui tab region, gen(d_reg)
drop d_reg1

* Dummies on the three education types
replace educ_att=1 if educ_att==2
replace educ_att=2 if educ_att==3
replace educ_att=3 if educ_att==4 | educ_att==5

qui tab educ_att, gen (d_educ)
drop d_educ3   // Drop the lowest type of education

gen hhss=exp(lnumhh)

qui tab age, gen(d_age)
drop d_age1

qui tab year, gen(yrd)
drop yrd1

gen d_mar=0
replace d_mar=1 if mastat==1 | mastat==2

gen d_sex=0
replace d_sex=1 if sex==2

gen lnumhh_mar=lnumhh
replace lnumhh=0 if d_mar==0
replace lnumhh_mar=0 if d_mar==1

save "`location'\data\main_Y_L_UK.dta", replace
******************************************************************
*******            E5. Estimation of the residuals         *******
******************************************************************
gen y=lY_Lab

xi: reg y d_sex d_age* d_reg* yrd* i.d_mar*lnumhh if dum_ed==1
predict y_resid1 if dum_ed==1, resid
xi: reg y d_sex d_age* d_reg* yrd* i.d_mar*lnumhh if dum_ed==2
predict y_resid2 if dum_ed==2, resid

gen u= .
replace u=y_resid1 if dum_ed==1
replace u=y_resid2 if dum_ed==2

******************************************************************
*******              E4. Save the files                    *******
******************************************************************
preserve
keep if dum_ed==1

keep pid year age u

reshape wide age u, i(pid) j(year)
reshape long age u, i(pid) j(year)

gen ind_u   = u   < 1000 
mvencode _all, mv(-99999)

keep pid year u ind_u age 
order pid year u ind_u age 
outsheet pid year u ind_u age  using "`location'\data\residuals_Y_L_U.out", comma nonames replace


restore
keep if dum_ed==2

keep pid year age u

reshape wide age u, i(pid) j(year)
reshape long age u, i(pid) j(year)

gen ind_u   = u   < 1000 
mvencode _all, mv(-99999)

keep pid year u ind_u age 
order pid year u ind_u age 
outsheet pid year u ind_u age  using "`location'\data\residuals_Y_L_NU.out", comma nonames replace

**********************************************************************************************************************
**********************************************************************************************************************
**********************************************************************************************************************
*****************                       7. Household Annual Gross Income                         *********************
**********************************************************************************************************************
**********************************************************************************************************************
**********************************************************************************************************************
**********************************************************************************************************************
use "`location'\data\main_Y_L_UK.dta", clear 

******************************************************************
*******            E5. Estimation of the residuals         *******
******************************************************************
gen y=lY


xi: reg y d_sex d_age* d_reg* yrd* i.d_mar*lnumhh if dum_ed==1
predict y_resid1 if dum_ed==1, resid
xi: reg y d_sex d_age* d_reg* yrd* i.d_mar*lnumhh if dum_ed==2
predict y_resid2 if dum_ed==2, resid

gen u= .
replace u=y_resid1 if dum_ed==1
replace u=y_resid2 if dum_ed==2

******************************************************************
*******              E4. Save the files                    *******
******************************************************************
preserve
keep if dum_ed==1

keep pid year age u

reshape wide age u, i(pid) j(year)
reshape long age u, i(pid) j(year)

gen ind_u   = u   < 1000 
mvencode _all, mv(-99999)

keep pid year u ind_u age 
order pid year u ind_u age 
outsheet pid year u ind_u age  using "`location'\data\residuals_Y_U.out", comma nonames replace


restore
keep if dum_ed==2

keep pid year age u

reshape wide age u, i(pid) j(year)
reshape long age u, i(pid) j(year)

gen ind_u   = u   < 1000 
mvencode _all, mv(-99999)

keep pid year u ind_u age 
order pid year u ind_u age 
outsheet pid year u ind_u age  using "`location'\data\residuals_Y_NU.out", comma nonames replace		

**********************************************************************************************************************
**********************************************************************************************************************
**********************************************************************************************************************
*****************              6. Household Annual Total Earnings plus Benefits                  *********************
**********************************************************************************************************************
**********************************************************************************************************************
**********************************************************************************************************************
**********************************************************************************************************************
use "`location'\data\main_Y_L_UK.dta", clear

******************************************************************
*******            E5. Estimation of the residuals         *******
******************************************************************
gen y=lY_b


xi: reg y d_sex d_age* d_reg* yrd* i.d_mar*lnumhh if dum_ed==1
predict y_resid1 if dum_ed==1, resid
xi: reg y d_sex d_age* d_reg* yrd* i.d_mar*lnumhh if dum_ed==2
predict y_resid2 if dum_ed==2, resid

gen u= .
replace u=y_resid1 if dum_ed==1
replace u=y_resid2 if dum_ed==2

******************************************************************
*******              E4. Save the files                    *******
******************************************************************
preserve
keep if dum_ed==1

keep pid year age u

reshape wide age u, i(pid) j(year)
reshape long age u, i(pid) j(year)

gen ind_u   = u   < 1000 
mvencode _all, mv(-99999)

keep pid year u ind_u age 
order pid year u ind_u age 
outsheet pid year u ind_u age  using "`location'\data\residuals_Y_B_U.out", comma nonames replace


restore
keep if dum_ed==2

keep pid year age u

reshape wide age u, i(pid) j(year)
reshape long age u, i(pid) j(year)

gen ind_u   = u   < 1000 
mvencode _all, mv(-99999)

keep pid year u ind_u age 
order pid year u ind_u age 
outsheet pid year u ind_u age  using "`location'\data\residuals_Y_B_NU.out", comma nonames replace

**********************************************************************************************************************
**********************************************************************************************************************
**********************************************************************************************************************
*****************              6. Household Annual Gross Income minus Taxes                      *********************
**********************************************************************************************************************
**********************************************************************************************************************
**********************************************************************************************************************
**********************************************************************************************************************
use "`location'\data\main_Y_L_UK.dta", clear

******************************************************************
*******            E5. Estimation of the residuals         *******
******************************************************************
gen y=lY_t


xi: reg y d_sex d_age* d_reg* yrd* i.d_mar*lnumhh if dum_ed==1
predict y_resid1 if dum_ed==1, resid
xi: reg y d_sex d_age* d_reg* yrd* i.d_mar*lnumhh if dum_ed==2
predict y_resid2 if dum_ed==2, resid

gen u= .
replace u=y_resid1 if dum_ed==1
replace u=y_resid2 if dum_ed==2

******************************************************************
*******              E4. Save the files                    *******
******************************************************************
preserve
keep if dum_ed==1

keep pid year age u

reshape wide age u, i(pid) j(year)
reshape long age u, i(pid) j(year)

gen ind_u   = u   < 1000 
mvencode _all, mv(-99999)

keep pid year u ind_u age 
order pid year u ind_u age 
outsheet pid year u ind_u age  using "`location'\data\residuals_Y_T_U.out", comma nonames replace


restore
keep if dum_ed==2

keep pid year age u

reshape wide age u, i(pid) j(year)
reshape long age u, i(pid) j(year)

gen ind_u   = u   < 1000 
mvencode _all, mv(-99999)

keep pid year u ind_u age 
order pid year u ind_u age 
outsheet pid year u ind_u age  using "`location'\data\residuals_Y_T_NU.out", comma nonames replace

**********************************************************************************************************************
**********************************************************************************************************************
**********************************************************************************************************************
*****************              6. Household Annual Gross Income minus Taxes                      *********************
**********************************************************************************************************************
**********************************************************************************************************************
**********************************************************************************************************************
**********************************************************************************************************************
use "`location'\data\main_Y_L_UK.dta", clear

******************************************************************
*******            E5. Estimation of the residuals         *******
******************************************************************
gen y=lY_n


xi: reg y d_sex d_age* d_reg* yrd* i.d_mar*lnumhh if dum_ed==1
predict y_resid1 if dum_ed==1, resid
xi: reg y d_sex d_age* d_reg* yrd* i.d_mar*lnumhh if dum_ed==2
predict y_resid2 if dum_ed==2, resid

gen u= .
replace u=y_resid1 if dum_ed==1
replace u=y_resid2 if dum_ed==2

******************************************************************
*******              E4. Save the files                    *******
******************************************************************
preserve
keep if dum_ed==1

keep pid year age u

reshape wide age u, i(pid) j(year)
reshape long age u, i(pid) j(year)

gen ind_u   = u   < 1000 
mvencode _all, mv(-99999)

keep pid year u ind_u age 
order pid year u ind_u age 
outsheet pid year u ind_u age  using "`location'\data\residuals_Y_N_U.out", comma nonames replace


restore
keep if dum_ed==2

keep pid year age u

reshape wide age u, i(pid) j(year)
reshape long age u, i(pid) j(year)

gen ind_u   = u   < 1000 
mvencode _all, mv(-99999)

keep pid year u ind_u age 
order pid year u ind_u age 
outsheet pid year u ind_u age  using "`location'\data\residuals_Y_N_NU.out", comma nonames replace

