function [PROBLEM, C, H] = GQ_Solution(teta)

global sigma 
global alpha 
global beta 
global phi_pi
global phi_x 
global omega
global rho_r 
global rho_z 
global theta
% global sigma_z
% global sigma_r 

alpha = teta(1);

kappa =( ((1-alpha)*(1-alpha*beta))/alpha )*( (omega+sigma)/(sigma*(omega+theta)));

C=1;
H=1;
M=5;
PROBLEM=0;
% lags=1;
nerr=2;

G0=[1 0 -kappa 0 0;
    -(1-rho_r)*phi_pi 1 -(1-rho_r)*phi_x 0 -1;
    0 sigma 1 -sigma 0;
    0 0 0 1 0;
    0 0 0 0 1];

Gb=[0 0 0 0 0; 
    0 rho_r 0 0 0; 
    0 0 0 0 0;
    0 0 0 rho_z 0;
    0 0 0 0 0;];

Gf=[beta 0 0 0 0;
    0 0 0 0 0;
    sigma 0 1 0 0;
    0 0 0 0 0;
    0 0 0 0 0];

D1=[0 0;
    0 0;
    0 0;
    1 0;
    0 1;
    ];

%% Start of BinderPesaran Code
N = 50; % Initial Forecasting Horizon (See Binder and Pesaran, 1995)

% Chat=GAM0;
% Ahat=GAMb;
% Bhat=GAMf;
% D1=[eye(M);...
%     zeros(M*(lags-1),M)];
% D2=zeros(M*lags,M);
% 
% Gamma=zeros(M,M);

Chat=G0;
Ahat=Gb;
Bhat=Gf;
% D1=[eye(M)];
D2=zeros(M,nerr);

Gamma=zeros(nerr,nerr);

% Set Up the System
% Chat * x[t] = Ahat * x[t-1] + Bhat * E(x[t+1]|I[t])
%               + D1 * w[t] + D2 * E(w[t+1]|I[t])
% w[t] = Gamma * w[t-1] + v[t]

% Variables Are in Logs, 'Detrended', and in Deviations
% From Steady State
% First Row of x(t): Capital
% Second Row of x(t): Hours
% Third Row of x(t): Consumption
% Fourth Row of x(t): Output
% Fifth Row of x(t): Investment
% First Row of w(t): Technology Shock
% Second Row of w(t): Government Expenditure

% Transform System to Canonical Form:
% x[t] = A * x[t-1] + B * E(x[t+1]|I[t]) 
%        + inv(Chat) * D1 * w[t] + inv(Chat) * D2 * E(w[t+1]|I[t])
B = inv(Chat)*Bhat;
A = inv(Chat)*Ahat;

[dim1,dim2] = size(A);
[dim3,dim4] = size(Gamma);

% Compute Matrix C Using Brute-Force Iterative Procedure
C = eye(dim1);          % Initial Condition
F = eye(dim1);          % Initial Condition
eps1 = 10^(-3);         % Convergence Criterion for F
eps2 = 10^(-3);         % Convergence Criterion for C
crit1 = 1; crit2 = 1;   % Initial Conditions
iter = 0;
while crit1 >= eps1 | crit2 >= eps2
   Fi = (eye(dim1)-B*C)\B;
   Ci = (eye(dim1)-B*C)\A;
   crit1 = max(max(abs(Fi-F))); crit2 = max(max(abs(Ci-C)));
   C = Ci; F = Fi;
   iter = iter+1;
   if iter > 500
%       disp(' The brute-force iterative procedure did not converge after ')
%       disp(' 500 iterations. See Binder and Pesaran (1995, 1997) for alternative ')
%       disp(' algorithms to compute the matrix C. '),
    PROBLEM=1;
    return
   end
end

% Use Recursive Method of Binder and Pesaran (1995) to Compute the 
% Forward Part of the Solution - Determine N
eps3 = 10^(-6);        % Convergence Criterion
i = 0;
aux3a = zeros(dim1,dim3);
aux3b = zeros(dim1,dim3);
fp1=[];
fp2=[];

while i <= N
   fp1 = F^i/(eye(dim1)-B*C)/Chat*D1*Gamma^i;
   fp2 = F^i/(eye(dim1)-B*C)/Chat*D2*Gamma^(i+1);
   aux3a = fp1+aux3a;
   aux3b = fp2+aux3b;
   i = i+1;
end
crit3 = max(max(abs(fp1+fp2)));

while crit3 > eps3
   N = N+1;
   fp1 = F^N/(eye(dim1)-B*C)/Chat*D1*Gamma^N;
   fp2 = F^N/(eye(dim1)-B*C)/Chat*D2*Gamma^(N+1);
   aux3a = fp1+aux3a;
   aux3b = fp2+aux3b;
   crit3 = max(max(abs(fp1+fp2)));
end
H = aux3a+aux3b;

% C=[C+H*R*inv(H) -H*R*inv(H)*C;
%     eye(M) zeros(M,M)];

end 