

libname lps '/rsma/corelogic_lps';
libname local '.';
libname dropoff '/href/scratch3/m1mbf00/';
libname abs '/rsma/corelogic_abs';

/* Part I: LPS data */    
data mort_lps (
    /* Add new LPS variables here: */
         keep = loan_id year ltv_ratio dti_ratio fico_orig appraisal_amt
         prop_zip document_type occupancy_type frm_arm loan_type orig_amt
         prop_state orig_dt jumbo_flg cl_flag close_dt thirty_year_loan);
    set lps.static_all 
        (where=(
        (year(close_dt)>2000) and        
        prop_type='1' and
        lien_type='1' and
        mort_type='1' and /* Prime restriction */
        (loan_type in ('2','3','C','D')) and
        (int_type in ('1','2')) and
        (purpose_type_mcdash='1')
        )
        );
    cl_flag=0;
    /* Add interest rate type identifier */
    if int_type=1 then do;
        frm_arm="FRM";
    end;
    else if int_type=2 then do;
        frm_arm="ARM";
    end;
    else do;
        frm_arm="ERROR";
    end;
    /* Add 30-year term identifier */
    if term_nmon = 360 then do;
        thirty_year_loan = 1;
    end;
    else if term_nmon ~= 360 then do;
        thirty_year_loan = 0;
    end;
    year=year(close_dt);
run;

/* Part II: Corelogic data */    
data mort_abs (
    /* Add new Corelogic variables here: */
               keep = loan_id year ltv_ratio dti_ratio_back fico_orig
               appraisal_amt prop_zip document_type occupancy_type
               frm_arm loan_type orig_amt prop_state orig_dt cl_flag close_dt thirty_year_loan
               rename=(dti_ratio_back=dti_ratio));
    set abs.abs_static 
        (
        where=(
        (year(close_dt)>2000) and
        prop_type='1' and
        lien_type='1' and
        (mort_type in ('1','4')) and /* Subprime restriction, EA changed from 4 to 1and4 */
        (int_type in ('1','2')) and
        (purpose_type_lp='1')
        )
        );
    cl_flag=1;
    /* Add interest rate type identifier */    
    if int_type=1 then do;
        frm_arm="FRM";
    end;
    else if int_type=2 then do;
        frm_arm="ARM";
    end;
    else do;
        frm_arm="ERROR";
    end;
    year=year(close_dt);
    /* Add 30-year term identifier */
    if term_nmon = 360 then do;
        thirty_year_loan = 1;
    end;
    else if term_nmon ~= 360 then do;
        thirty_year_loan = 0;
    end;
run;

/* Part III: Combine LPS, Corelogic, and zip-to-cbsa crosswalk */
data ltv_dti_fico;
    set mort_lps mort_abs;
run;

/* Attach crosswalk */
data ltv_dti_fico;
    set ltv_dti_fico;
run;

data crosswalk;
    set local.zipcbsa_crosswalk;
run;
    
proc sort data=ltv_dti_fico;
    by prop_zip;
run;

proc sort data=crosswalk;
    by prop_zip;
run;

data ltv_dti_fico crossonly;
    merge ltv_dti_fico(in=a) crosswalk(in=b);
    by prop_zip;
    if a then output ltv_dti_fico;
    else output crossonly;
run;

/* Part IV: Attach dynamic information and create loan type identifiers */
proc sort data=dropoff.dynamic;
    by loan_id;
run;

proc sort data=ltv_dti_fico;
    by loan_id;
run;

data dropoff.ltv_dti_fico dynonly;
    merge dropoff.dynamic (in=dyn) ltv_dti_fico (in=stat);
    by loan_id;
    /* Create loan type variable */
    if cl_flag=1 then do;
        type='corelogic';
    end;
    else if cl_flag=0 then do;
        if jumbo_flg='Z' then do; 
            type='jumbo';
        end;
        else if jumbo_flg^='Z' then do;            
            if loan_type in ('2','3') then do;
                type='fhava'; 
            end;
            else if loan_type in ('C','D') then do;            
                if investor_type in ('2','3') then do;
                    type='gse';
                end;
                else if investor_type='7' then do;
                    type='portfolio';
                end;
                else if investor_type='4' then do;
                    type='rmbs';
                end;
            end;
        end;
    end;
        if dyn and not stat then output dynonly;
    else output dropoff.ltv_dti_fico;
run;        

/* ltv_dti_fico.csv has all loans in both datasets, whereas ltv_dti_fico_nodups.csv */
/* should have only prime loans from LPS and only subprime loans from CoreLogic     */
proc export data=dropoff.ltv_dti_fico
    file='/href/scratch3/m1mbf00/ltv_dti_fico_nodups_new.csv'
    replace;
run;

proc print data=ltv_dti_fico(obs=1000);
run; 
