libname lps '/rsma/corelogic_lps';
libname dropoff '/href/scratch3/m1jlp02';

/****/
/* Part I: make temporary datasets for each month that will be concatenated */
/****/    
    
/* Pull in data, keep only relevant variables */
%MACRO loopthru(year=,month=);
    
data dyn&year.&month.;
    set lps.dynamic&year.&month. (keep=loan_id cur_int_rate investor_type);
    year="&year.";
    month="&month.";
run;

%MEND loopthru;

/* Loop through all years */
data _null_;
    do y=2000 to 2014;
        do m=1 to 12;
            if m<10 then do;
                line=cats('%loopthru(year=',y,',month=0',m,');');
                call execute(line);
            end;
            else if m>=10 then do;
                line=cats('%loopthru(year=',y,',month=',m,');');
                call execute(line);
            end;
        end;
    end;
run;

%loopthru(year=2015,month=01);
%loopthru(year=2015,month=02);
%loopthru(year=2015,month=03);
%loopthru(year=2015,month=04);
%loopthru(year=2015,month=05);


/* Concatenate all months */
data dropoff.dynamic;
    set dyn:;
run;

/*****/
/* Part II: Identify what a loan was three months after origination */
/*****/    
proc sort data=dropoff.dynamic;
    by loan_id year month;
run;

/* Identify and separate out interest rate and loan type information */
data rates (drop=investor_type lag3_first lag3_loan_id first
            rename=(year=rate_year month=rate_month))
     loantype (drop=cur_int_rate lag3_first lag3_loan_id first
               rename=(year=inv_year month=inv_month));
    set dropoff.dynamic;
    by loan_id;
    if first.loan_id then do;
        first=1;
    end;    
    lag3_first=lag3(first);
    lag3_loan_id=lag3(loan_id);
    if first=1 then do;
        output rates;
    end;
    if (lag3_first=1) and (lag3_loan_id=loan_id) then do;
        output loantype;
    end;
run;

/* Combine dynamic info, save */
data dropoff.dynamic;
    merge rates loantype;
    by loan_id;
run;
    
proc print data=dropoff.dynamic;
run;
