clc; clear; close all
load('data10_00.mat')
tit = {'2010','2000',' Growth rate'};
N = size(data10_00,1);
data10_00(data10_00(:,1) == 0,:) = [];
data10_00(data10_00(:,2) == 0,:) = [];
ldata = log(data10_00);
n = size(ldata,1);
nn = 5000000; % for the marginal Normal approximation

logsize10 = ldata(:,1);
logsize00 = ldata(:,2);
logsizeg = ldata(:,1) - ldata(:,2);

for i=1:n
    type(i) = 0;% both
    
end
for i=n+1:n+nn
    type(i) = 2010;% 2010 or growth
end
for i=n+nn+1:n+nn*2
    type(i) = 2000;
end

% get the marginal dist
mu10 = mean(ldata(:,1));
sigma10 = std(ldata(:,1));    
logsize00 = [logsize00; NaN(nn,1)];
logsize10 = [logsize10; normrnd(mu10,sigma10,nn,1)];

mug = mean(ldata(:,1) - ldata(:,2));
sigmag = std(ldata(:,1) - ldata(:,2));   
logsizeg  = [logsizeg;  normrnd(mug,sigmag,nn,1)];

mu00 = mean(ldata(:,2));
sigma00 = std(ldata(:,2));    
logsize00 = [logsize00; normrnd(mu00,sigma00,nn,1)];
logsize10 = [logsize10;NaN(nn,1)];
logsizeg = [logsizeg; NaN(nn,1)];

figure(1)
h=scatterhist(logsize00,logsize10,'Group',type,'Legend','off','Kernel','on','Location','SouthEast',...
    'Direction','out','Color','k','LineStyle',{'-',':',':'},...
    'LineWidth',[1,.5,.5],'Marker','+od','MarkerSize',3);
% set(h,{'color'},{[1,1,1];[0.2,0.2,.6];[0.2,0.2,.6]});
xlabel('2000 census')
ylabel('2010 census')
set(gco,'fontname','times','fontsize',9);
set(gca,'linewidth',.1,'fontname','times','fontsize',9);

figure(2)
h = scatterhist(logsize00,logsizeg,'Group',type,'Legend','off','Kernel','on','Location','SouthEast',...
    'Direction','out','color','k','LineStyle',{'-',':',':'},...
    'LineWidth',[1,.5,.5],'Marker','+od','MarkerSize',3);
% set(h,{'Color'},{[.2,.2,.6];[.2,.2,.6];[.6,.2,.2];[.2,.2,.6];[.6,.2,.2]})
xlabel('2000 census')
ylabel('Growth')
set(gco,'fontname','times','fontsize',9);
set(gca,'linewidth',0.1,'fontname','times','fontsize',9);
