function output = plotarea(datamat,xlabel)

ha1 = area([datamat(:,1) datamat(:,end)-datamat(:,1)],'linestyle','none');
hold on;
set(ha1(1), 'FaceColor', 'none'); set(ha1(2), 'FaceColor', [0.9 0.9 0.9])    

if size(datamat,2)>3
    ha2 = area([datamat(:,2) datamat(:,end-1)-datamat(:,2)],'linestyle','none');
    set(ha2(1), 'FaceColor', 'none'); set(ha2(2), 'FaceColor', [0.7 0.7 0.7])    

    output = plot(datamat(:,3),'k','linewidth',1); axis tight;
else
    output = plot(datamat(:,2),'k','linewidth',1); axis tight;
end

plot(zeros(size(datamat,1),1),'k','linewidth',0.5) 

xticks(xlabel+1)
xticklabels(cellstr(num2str(xlabel')))

end