function [B, rsh, rr]  = VARest_boot(X, opts)

p = opts.dfm.phat;
h = opts.h;

N = size(X, 2);
T = size(X, 1);

B = NaN(N,N,h+1,opts.nboot);
rsh = NaN(T-p,N,opts.nboot);
rr = NaN(T-p,opts.nboot);
% 
% W = [ones(T,1) Z];
% AA = (W'*W)\W'*X;
% chi = W*AA;
% 
% Idio = X-chi;
% IdioBoot = NaN([size(Idio),opts.nboot]);
% 

RHS = NaN(T-p,N*p);
for i = 1:p
    RHS(:,1+(i-1)*size(X,2):i*size(X,2)) = X(p+1-i:end-i,:);
end

LHS      = X(p+1:end,:);
bet = [RHS ones(length(RHS),1)]\LHS; 
u = LHS-[RHS ones(length(RHS),1)]*bet;

%% Kilian bias correction
k=size(X,2);
SIGMA = zeros(p*k);    
SIGMA(1:k,1:k) = u'*u/(T-p-p*k-1);	
% coeffcompanion = zeros(p*k);
% for pi=1:p
%     coeffcompanion(1:k,1+(pi-1)*k:k*pi) = bet(1+(pi-1)*k:pi*k,:)';
% end
% coeffcompanion(k+1:end,1:p*k-k) = eye(k*p-k);

coeffcompanion = [bet(1:p*k,:)'; eye((p-1)*k), zeros((p-1)*k,k)];


biascorr=kiliancorr(coeffcompanion,SIGMA,T,k,p);

betbiasc = [biascorr(1:k,:)'; bet(end,:)]; 
%%

res = u-repmat(mean(u),size(u,1),1);

%% wild bootstrap procedure
% cf. Gertler & Karadi (2015) and Mertens & Ravn (2013)

for j=1:opts.nboot  
    X_boot = zeros(p+size(LHS,1),size(LHS,2));
    X_boot(1:p,:)=X(1:p,:);
    rr(:,j) = 1-2*(rand(size(LHS,1),1)>0.5);
    resb = (res.*(rr(:,j)*ones(1,size(LHS,2))))';
            
        for jj=p+1:p+size(LHS,1)
            lvars = (X_boot(jj-1:-1:jj-p,:))';
            X_boot(jj,:) = lvars(:)'*betbiasc(1:p*size(LHS,2),:)+betbiasc(p*size(LHS,2)+1:end,:)+resb(:,jj-p)';
        end
    
%         for i=1:size(Idio,2)
%             if ismember(i,variables)~=1
%                 % estimate AR(4) on idio part
%                 [tempIRFidio, epsilon, ~] = woldimpulse(Idio(:,i), 4, 50, 1);
%                 IRFidio = squeeze(tempIRFidio); 
%                 % draw idio part from normal dist
%                 epsilon_boot = normrnd(0,std(epsilon),size(IdioBoot,1),1); 
%                 tempidio_boot = filter(IRFidio,1,epsilon_boot);
%                 IdioBoot(:,i,j) = tempidio_boot(1:end);
%             else
%                 IdioBoot(:,i,j) = zeros(size(IdioBoot,1),1);
%             end
%         end
        
%     W_boot = [ones(size(X,1),1) Z_boot];    
%     X_boot = W_boot*AA + IdioBoot(:,:,j);    
    [B(:,:,:,j), rsh(:,:,j)] = VARest(X_boot, opts);
end