function [B, rsh]  = VARest(X, opts)

p = opts.dfm.phat;
h = opts.h;

[T, N] = size(X);
RHS = NaN(T-p,N*p);
for i = 1:p
    RHS(:,1+(i-1)*N:i*N) = X(p+1-i:end-i,:);
end

LHS      = X(p+1:end,:);
bet = [RHS ones(length(RHS),1)]\LHS; 
rsh = LHS-[RHS ones(length(RHS),1)]*bet;


coeffcompanion = [bet(1:p*N,:)'; eye((p-1)*N), zeros((p-1)*N,N)];

Bfull = NaN*ones(N*p,N*p,h);
Bfull(:,:,1) = eye(N*p);
Bfull(:,:,2) = coeffcompanion;
for i = 3:h+1
   Bfull(:,:,i) = Bfull(:,:,i-1)*coeffcompanion;
end


B  = NaN*ones(N,N,h+1);
for i = 1:h+1
   B(:,:,i) = Bfull(1:N,1:N,i);
end
