
plotlabels = X.labels(getind(X.names,opts.robfigvars));

titleposition = [0.5 1 0];

N = size(X.data,2);

%% lag length
IRF_rob_p = NaN(N,opts.h+1,length(opts.rob_p));
for i=1:length(opts.rob_p)
    opts_rob = opts;
    opts_rob.dfm.phat = opts.rob_p(i);   

    [BB_dfm, u_dfm] = DFMest_BLL(X.data,opts_rob); 
    [u_dfm_sel, inst_sel] = selextinstsample(X.data,X.dates,u_dfm,hfinst);
    [IRF_rob_p(:,:,i)] = IdentExtInstr(BB_dfm, X.tcode, X.names, opts_rob, u_dfm(u_dfm_sel,:), inst_sel);
end

figure;
for i=1:length(opts.robfigvars)
    subplot(3,2,i);
    plotarea(squeeze(IRF_dfm(getind(X.names,opts.robfigvars(i)),:,:)),opts.xlabel); grid on;    
    title(plotlabels{i},'Units','normalized','position',titleposition,'interpreter','none');
    hold on;
    h = plot(squeeze(IRF_rob_p(getind(X.names,opts.robfigvars(i)),:,:)));
    set(h,{'LineStyle'},{'--';'-.';'-'}); 
    set(h,{'Color'},{'b';'r';'g'})
    set(h(end),{'Marker'},{'*'}); set(h(end),'MarkerSize',4)
end

%% number of static factors
IRF_rob_r = NaN(N,opts.h+1,length(opts.rob_r));
for i=1:length(opts.rob_r)
    opts_rob = opts;
    opts_rob.dfm.rhat = opts.rob_r(i);   
    opts_rob.dfm.qhat = min(opts_rob.dfm.rhat,opts.dfm.qhat);
    [BB_dfm, u_dfm] = DFMest_BLL(X.data,opts_rob); 
    [u_dfm_sel, inst_sel] = selextinstsample(X.data,X.dates,u_dfm,hfinst);
    [IRF_rob_r(:,:,i)] = IdentExtInstr(BB_dfm, X.tcode, X.names, opts_rob, u_dfm(u_dfm_sel,:), inst_sel);
end

figure;
for i=1:length(opts.robfigvars)
    subplot(3,2,i);
    plotarea(squeeze(IRF_dfm(getind(X.names,opts.robfigvars(i)),:,:)),opts.xlabel); grid on;    
    title(plotlabels{i},'Units','normalized','position',titleposition,'interpreter','none');
    hold on;
    h = plot(squeeze(IRF_rob_r(getind(X.names,opts.robfigvars(i)),:,:)));
    set(h,{'LineStyle'},{'--';'-.';'-'}); 
    set(h,{'Color'},{'b';'r';'g'})
    set(h(end),{'Marker'},{'*'}); set(h(end),'MarkerSize',4)
end

%% number of dynamic factors
IRF_rob_q = NaN(N,opts.h+1,length(opts.rob_q));
for i=1:length(opts.rob_q)
    opts_rob = opts;
    opts_rob.dfm.qhat = opts.rob_q(i);   

    [BB_dfm, u_dfm] = DFMest_BLL(X.data,opts_rob); 
    [u_dfm_sel, inst_sel] = selextinstsample(X.data,X.dates,u_dfm,hfinst);
    [IRF_rob_q(:,:,i)] = IdentExtInstr(BB_dfm, X.tcode, X.names, opts_rob, u_dfm(u_dfm_sel,:), inst_sel);
end

figure;
for i=1:length(opts.robfigvars)
    subplot(3,2,i);
    plotarea(squeeze(IRF_dfm(getind(X.names,opts.robfigvars(i)),:,:)),opts.xlabel); grid on;    
    title(plotlabels{i},'Units','normalized','position',titleposition,'interpreter','none');
    hold on;
    h = plot(squeeze(IRF_rob_q(getind(X.names,opts.robfigvars(i)),:,:)));
    set(h,{'LineStyle'},{'--';'-.';'-'}); 
    set(h,{'Color'},{'b';'r';'g'})
    set(h(end),{'Marker'},{'*'}); set(h(end),'MarkerSize',4)
end