%% Estimate dynamic factor model

N = size(X.data,2);
%% pre-allocate IRFs and shocks
IRF_dfm = NaN(N,opts.h+1,5);
IRFdfm_b = NaN(N,opts.h+1,opts.nboot);

%% reduced-form estimation
[BB_dfm, u_dfm] = DFMest_BLL(X.data,opts); 
[BB_dfm_b, u_dfm_b, rr_dfm_b] = DFMest_BLL_Boot(X.data,opts);

%% external instrument identification
[u_dfm_sel, inst_dfm_sel] = selextinstsample(X.data,X.dates,u_dfm,hfinst);
[IRF_dfm(:,:,3),H_dfm] = IdentExtInstr(BB_dfm, X.tcode, X.names, opts, u_dfm(u_dfm_sel,:), inst_dfm_sel);

% Bootstrap
for ii=1:opts.nboot
    [u_dfm_sel_b, inst_dfm_sel_b] = selextinstsample(X.data,X.dates,u_dfm_b(:,:,ii),hfinst,rr_dfm_b(:,ii));                    
    [IRFdfm_b(:,:,ii)] = IdentExtInstr(BB_dfm_b(:,:,:,ii), X.tcode, X.names, opts, u_dfm_b(u_dfm_sel_b,:,ii), inst_dfm_sel_b);  
end
IRF_dfm(:,:,1) = prctile(IRFdfm_b,5,3);
IRF_dfm(:,:,2) = prctile(IRFdfm_b,10,3);
IRF_dfm(:,:,4) = prctile(IRFdfm_b,90,3);
IRF_dfm(:,:,5) = prctile(IRFdfm_b,95,3);