% identification (of mon pol shock) with external instrument, cf. Gertler & Karadi code
function [imp_mp_std_cum, H] = IdentExtInstr(rawimp, tcode, names, opts, rsh, Z)

% demean reduced form shocks and regress on instrument
rsh_mean0 = rsh-repmat(mean(rsh),size(Z,1),1);
H = (Z\rsh_mean0)';

imp_mp = NaN(size(rawimp,1),size(rawimp,3));
for j =  1:opts.h+1
    imp_mp(:,j) = rawimp(:,:,j)*H;
end

% standardize impact effect of selected variable
imp_mp_std = imp_mp./imp_mp(getind(names,opts.mpind),1)*.5;
imp_mp_std_cum = cumimp(imp_mp_std,tcode);

end

function CC = cumimp(Imp, Transf)
notransf =     find(Transf==1);
firstdiff =    find(Transf==2);
seconddiff =   find(Transf==3);
loglevel =     find(Transf==4);
firstlogdiff = find(Transf==5);
CC = Imp*0;
CC(notransf,:) =                    Imp(notransf,:);
CC(firstdiff,:) =         cumsum(   Imp(firstdiff,:),2)*100;
CC(firstlogdiff,:) = (exp(cumsum(   Imp(firstlogdiff,:),2))-1)*100;
CC(seconddiff,:) = cumsum(cumsum(   Imp(seconddiff,:),2),2);
CC(loglevel,:) =     (exp(          Imp(loglevel,:))-1)*100;
end 