
function [C, eta]  = DFMest_BLL(Y, opts)

q = opts.dfm.qhat;
r = opts.dfm.rhat;
p = opts.dfm.phat;
h = opts.h;
T = size(Y,1);

C = NaN(size(Y,2),q,h+1);

%% the following code is based on Barigozzi, Lippi, Luciani (2016): Non-Stationary Dynamic Factor Models for Large Datasets
% see http://www.barigozzi.eu/BLL_ReplicationFiles.zip

y=Y(2:end,:)-Y(1:end-1,:);                                                   % 1st Differences                                         
sy = std(y);                                                                 % Standardize
yy = (y-repmat(mean(y),T-1,1))./repmat(sy,T-1,1);
regX = [ones(T,1) (1:T)'];                                                   % Detrend Data
beta = regX\Y;
X = Y-regX*beta;
Z=X./repmat(sy,size(X,1),1);                                                 % BLL - Standardization 

opt.disp = 0;
[W, ~] = eigs(cov(yy), r,'LM',opt);
lambda= W;
F=Z*lambda;                                                                  % static factors

%%
RHS = NaN(T-p,r*p);
for i = 1:p
    RHS(:,1+(i-1)*r:i*r) = F(p+1-i:end-i,:);
end

LHS = F(p+1:end,:);
bet = [RHS ones(length(RHS),1)]\LHS; 
u = LHS-[RHS ones(length(RHS),1)]*bet;

coeffcompanion = [bet(1:p*r,:)'; eye((p-1)*r), zeros((p-1)*r,r)];

Bfull = NaN*ones(r*p,r*p,h);
Bfull(:,:,1) = eye(r*p);
Bfull(:,:,2) = coeffcompanion;
for i = 3:h+1
   Bfull(:,:,i) = Bfull(:,:,i-1)*coeffcompanion;
end

B  = NaN*ones(r,r,h+1);
for i = 1:h+1
   B(:,:,i) = Bfull(1:r,1:r,i);
end
%%

if q==r
    K=1;
    M=1;
else
    [ K, MM ] = eigs(cov(u), q, 'LM',opt);
    M = diag(sqrt(diag(MM)));
end

eta = u*K/M;                                                               % dynamic factors
for ii=1:h+1; C(:,:,ii)=(lambda*B(:,:,ii)*K*M).*repmat(sy',1,q); end;      % IRFs of common components to reduced-form dynamic factors

end
