function f = ekf_PH3drec_hes(x)

global T;global Y;global xi0; global xi1; global P0; global P1; global F;
global d11;global d12;global d13;global d14;global Q;global R;global BD;global RD;
global r11;global r12;global r13;global r14;global L; global LL; global S;global ind65;

IND=ind65;
f1=1;f2=1;f3=1;f4=1;f5=1;
nn=4; nr=5; nt=48; qnt=nt*4;n=5;
 
%(3) variance for v: 6 numbers for q
% for sector: the loewr bound is 0.00001

  q1=x(1)^2;
  q2=x(2)^2;
  q3=x(3)^2; 
  q4=x(4)^2;
  
 R(1,1)=x(5)^2;
 R(2,2)=x(6)^2;
 R(3,3)=x(7)^2;
 R(4,4)=x(8)^2;
 R(5,5)=x(9)^2;

ff = [f1,0,0,0;...
      0,f2,0,0;...
      0,0,f3,0;...
      0,0,0,f4];
  
ff=eye(4);
F=zeros(4*nt,4*nt);

F(1:4,1:4)=ff;

for q=1:nt-1
F(1+4*q:4+4*q,1+4*(q-1):4+4*(q-1))=eye(4);
end

qq = [q1,0,0,0;...
      0,q2,0,0;...
      0,0,q3,0;...
      0,0,0,q4];

Q=zeros(4*nt,4*nt);
Q(1:4,1:4)=qq;

d11= x(10); %duration 2-3 m
d12= x(10); %duration 4-6 m
d13= x(11); %duration 7-12 m
d14= x(12); %duration 13+ m

r11= x(13); %duration 2-3 m
r12= x(13); %duration 4-6 m
r13= x(14); %duration 7-12 m
r14= x(15); %duration 13+ m

c=1;
sigma2 = 0.1;
I4 = c*eye(4,4);
S = zeros(192,192,48);
S(1:192,1:192,1)=kron(ones(48,48),I4);
for j=2:48
    S(4*(j-1)+1:192,4*(j-1)+1:192,j)=kron(ones(48-(j-1),48-(j-1)),(sigma2)*eye(4,4));
end

P0(:,:,1)=sum(S,3);

ll=ones(T,1);
PP=ones(T,2);
W=ones(T,2);

%% 2. forecast for y(yhat), xi(t|t-1), P1, P0,

JH1 = zeros(nr,4*nt,T);
JH = zeros(4*nt,nr,T);
VY = zeros(nr,nr,T);
yhat = zeros(nr,T);
xi1 = zeros(4*nt,T);
P1 = zeros(4*nt,4*nt,T);

%% matrix of derivatives %%

BD = zeros(nt,1); % matrix of duration dependence parameter
RD = zeros(nt,1); % matrix of duration dependence parameter

BD(1,1)=0;
RD(1,1)=0;

BD(2,1)=d11;
RD(2,1)=r11;

BD(3,1)=d11+d12;
RD(3,1)=r11+r12;

BD(4,1)=d11+2*d12;
RD(4,1)=r11+2*r12;

BD(5,1)=d11+3*d12;
RD(5,1)=r11+3*r12;

BD(6,1)=d11+3*d12+d13;
BD(7,1)=d11+3*d12+2*d13;
BD(8,1)=d11+3*d12+3*d13;
BD(9,1)=d11+3*d12+4*d13;
BD(10,1)=d11+3*d12+5*d13;
BD(11,1)=d11+3*d12+6*d13;

RD(6,1)=r11+3*r12+r13;
RD(7,1)=r11+3*r12+2*r13;
RD(8,1)=r11+3*r12+3*r13;
RD(9,1)=r11+3*r12+4*r13;
RD(10,1)=r11+3*r12+5*r13;
RD(11,1)=r11+3*r12+6*r13;


for i=12:23
BD(i,1)=d11+3*d12+6*d13+(i-11)*d14;
RD(i,1)=r11+3*r12+6*r13+(i-11)*r14;
end

for i=24:nt
BD(i,1)=d11+3*d12+6*d13+(23-11)*d14;
RD(i,1)=r11+3*r12+6*r13+(23-11)*r14;
end


tau = zeros(nt,nt);

 for i=1:nt
 for j=2:nt
     k=i-j+1;
     if k>0
     tau(i,j-1)=k;
     else 
     tau(i,j-1)=0;
     end
 end
 end

 MW1(:,:,:) = ones(nt,nt,T);
 MW2(:,:,:) = ones(nt,nt,T);
 MC1(:,:,:) = zeros(nt,nt,T);
 MC2(:,:,:) = zeros(nt,nt,T);
 MP1(:,:,:) = zeros(nt,nt,T);
 MP2(:,:,:) = zeros(nt,nt,T);
 D_MW1(:,:,:)=zeros(nt,nt,T);
 D_MW2(:,:,:)=zeros(nt,nt,T);
 D_MP1(:,:,:)=zeros(nt,nt,T);
 D_MP2(:,:,:)=zeros(nt,nt,T);
 M_JH1 = zeros(nt,qnt,T);

for t=1:T

if IND(t,1)==0;
 D=BD;
else IND(t,1)==1;
 D=RD;
end

 for i=1:nt
 W1(i,t) = xi0(1+4*(i-1),t);
 W2(i,t) = xi0(2+4*(i-1),t);
 X1(i,t) = xi0(3+4*(i-1),t);
 X2(i,t) = xi0(4+4*(i-1),t);
 end

 for i=2:nt
 for j=1:nt            
     if tau(i,j)>0
 MW1(i,j,t) = exp(-exp(X1(j,t)+D(tau(i,j),1)));
 MW2(i,j,t) = exp(-exp(X2(j,t)+D(tau(i,j),1)));
     else
 MW1(i,j,t) = 1;
 MW2(i,j,t) = 1;
 end
 end
 end

 D_MW1(1,1,t)= 1;
 D_MW2(1,1,t)= 1;
 
for j=1:nt
 D_MW1(j,j,t)= prod(MW1(j,:,t),2);
 D_MW2(j,j,t)= prod(MW2(j,:,t),2);
end

 MP1(1,:,t)=zeros(1,nt);
 MP2(1,:,t)=zeros(1,nt);

 for i=2:nt
 MP1(i,1:i-1,t)=W1(i,t)*D_MW1(i,i,t);
 MP2(i,1:i-1,t)=W2(i,t)*D_MW2(i,i,t);
 end

 MC1(1,:,t)=zeros(1,nt);
 MC2(1,:,t)=zeros(1,nt);

 for i=2:nt
 for j=1:nt 
     if tau(i,j)>0
 MC1(i,j,t) = -exp(X1(j,t)+D(tau(i,j),1));
 MC2(i,j,t) = -exp(X2(j,t)+D(tau(i,j),1));
     else
 MC1(i,j,t) = 0;
 MC2(i,j,t) = 0;
 end
 end
 end
 
 for i=1:nt
 for j=1:nt 
 D_MP1(i,j,t)= MP1(i,j,t).*MC1(i,j,t);
 D_MP2(i,j,t)= MP2(i,j,t).*MC2(i,j,t);
 end
 end

for i=1:nt
M_JH1(:,1+4*(i-1),t)=D_MW1(:,i,t);
M_JH1(:,2+4*(i-1),t)=D_MW2(:,i,t);
M_JH1(:,3+4*(i-1),t)=D_MP1(:,i,t);
M_JH1(:,4+4*(i-1),t)=D_MP2(:,i,t);
end

 UL(1,t)=W1(1,t)*D_MW1(1,1,t);
 UH(1,t)=W2(1,t)*D_MW2(1,1,t);
 TU(1,t)=UL(1,t)+UH(1,t);

for k=2:nt
 UL(k,t)=W1(k,t)*D_MW1(k,k,t);
 UH(k,t)=W2(k,t)*D_MW2(k,k,t);
 TU(k,t)=UL(k,t)+UH(k,t);
end

yhat(1,t)=TU(1,t);
yhat(2,t)=TU(2,t)+TU(3,t);
yhat(3,t)=TU(4,t)+TU(5,t)+TU(6,t);
yhat(4,t)=sum(TU(7:12,t),1);
yhat(5,t)=sum(TU(13:nt,t),1);

JH1(1,:,t)= M_JH1(1,:,t);
JH1(2,:,t)= M_JH1(2,:,t)+M_JH1(3,:,t);
JH1(3,:,t)= M_JH1(4,:,t)+M_JH1(5,:,t)+M_JH1(6,:,t);
JH1(4,:,t)= sum(M_JH1(7:12,:,t),1);
JH1(5,:,t)= sum(M_JH1(13:nt,:,t),1);

JH(:,:,t)=JH1(:,:,t)';

%(3)Variance of Y: E[(Y-EY)(Y-EY)'] 

VY(:,:,t)=(JH(:,:,t)')*P0(:,:,t)*(JH(:,:,t))+R; %+ 0.1*eye(5,5); % Variance of Y

%(4)\xi(t|t)
xi1(:,t)=xi0(:,t)+P0(:,:,t)*JH(:,:,t)/(VY(:,:,t))*(Y(t,:)'-yhat(:,t));
 
%(5)P(t|t)

P1(:,:,t) = P0(:,:,t)-P0(:,:,t)*JH(:,:,t)/(VY(:,:,t))*JH(:,:,t)'*P0(:,:,t);

% 3. Forecast of \xi
xi0(:,t+1) = F*xi1(:,t);

%(2) P0(t+1|t)
P0(:,:,t+1) =  F*P1(:,:,t)*F' + Q;

ll(t,1) = -(n/2)*log(2*pi)-(1/2)*log(det(VY(:,:,t)))...
    -(1/2)*((Y(t,:)'-yhat(:,t))'/(VY(:,:,t))*(Y(t,:)'-yhat(:,t)));
end

f =sum(ll(1:T,1),1); % finally, we want to find the initial values maximizing this

end
