
clear all

addpath('../result_files')

load tl_3prm_rec_e24_final

rs_WL(:,1) = smW(:,1);
clearvars -except rs_WL

load os_3prm_rec_e24_final
rs_WL(:,2) = smW(:,1);
clearvars -except rs_WL

load qt_3prm_rec_e24_final
rs_WL(:,3) = smW(:,1);
clearvars -except rs_WL

load re_3prm_rec_e24_final
rs_WL(:,4) = smW(:,1);
clearvars -except rs_WL

load ne_3prm_rec_e24_final
rs_WL(:,5) = smW(:,1);
clearvars -except rs_WL

% dates
for i=1:12
    tt(i,1)=1976+i/13;
end
for i=1:43*12;
    tt(i+12,1)=tt(i,1)+1;
end

t = tt(48:527,1); 
T = 480; 

rs_WL(:,6) = sum(rs_WL(:,1:5),2);

g1 = figure;
hold on
set(gca,'fontsize',15)
title('Type L inflows by reason for unemployment')
plot(t,rs_WL(1:T,1),':','LineWidth',2,'Color',[1 0 0])
plot(t,rs_WL(1:T,2),'--','LineWidth',4,'Color',[0 0 1])
plot(t,rs_WL(1:T,3),'-','LineWidth',3,'Color',[1 0 0])
plot(t,rs_WL(1:T,4),'--','LineWidth',2,'Color',[0 1 0])
plot(t,rs_WL(1:T,5),'-o','LineWidth',1,'Color',[0 0 0])
plot(t,rs_WL(1:T,6),'--','LineWidth',2,'Color',[1 0 1])
hleg1 = legend('TL','PS','JL','RE','NE','Sum','Orientation','Horizontal');
set(hleg1,'Location', 'Northeast') 
axis([1979.9,2019.9,0,1.3])
colorstr=[159 182 205]/256;
shade(t(2,1),t(8,1),colorstr);
shade(t(20,1),t(36,1),colorstr); 
shade(t(128,1),t(136,1),colorstr); 
shade(t(256,1),t(264,1),colorstr); 
shade(t(337,1),t(355,1),colorstr);
hold off
saveas(g1,'/figures/wl_rs','epsc');

for tt=1:T
share_WL(tt,1)=rs_WL(tt,1)/rs_WL(tt,6);
share_WL(tt,2)=rs_WL(tt,2)/rs_WL(tt,6);
share_WL(tt,3)=rs_WL(tt,3)/rs_WL(tt,6);
share_WL(tt,4)=rs_WL(tt,4)/rs_WL(tt,6);
share_WL(tt,5)=rs_WL(tt,5)/rs_WL(tt,6);
end

g2 = figure;
hold on
set(gca,'fontsize',15)
title('Share in type L inflows by reason for unemployment')
plot(t,share_WL(1:T,1),':','LineWidth',2,'Color',[1 0 0])
plot(t,share_WL(1:T,2),'--','LineWidth',4,'Color',[0 0 1])
plot(t,share_WL(1:T,3),'-','LineWidth',3,'Color',[1 0 0])
plot(t,share_WL(1:T,4),'--','LineWidth',2,'Color',[0 1 0])
plot(t,share_WL(1:T,5),'-o','LineWidth',1,'Color',[0 0 0])
hleg1 = legend('TL','PS','JL','RE','NE','Orientation','Horizontal');
set(hleg1,'Location', 'Northwest') 
axis([1979.9,2013.9,0,1])
colorstr=[159 182 205]/256;
shade(t(2,1),t(8,1),colorstr);
shade(t(20,1),t(36,1),colorstr); 
shade(t(128,1),t(136,1),colorstr); 
shade(t(256,1),t(264,1),colorstr); 
shade(t(337,1),t(355,1),colorstr);
hold off
saveas(g2,'/figures/wls_rs','epsc');
