%% white standard error using hessian %%

global T; % number of observation

program1 = @ekf_PH3drec_hes;
program2 = @ekf_PH3drec_jac;

% use the following two lines for temporary layoffs (not the two lines
% above)
% program1 = @ekf_PH3drec_hes_tl; % for TL
% program2 = @ekf_PH3drec_jac_tl; % for TL

sqs1 = sqrt(Q(1,1));sqs2 = sqrt(Q(2,2));sqs3 = sqrt(Q(3,3));sqs4 = sqrt(Q(4,4));
sqr1 = sqrt(R(1,1));sqr2 = sqrt(R(2,2));sqr3 = sqrt(R(3,3));sqr4 = sqrt(R(4,4));sqr5 = sqrt(R(5,5));
c1=d11;c2=d13;c3=d14;
c4=r11;c5=r13;c6=r14;

x0 = [sqs1,sqs2,sqs3,sqs4,sqr1,sqr2,sqr3,sqr4,sqr5,c1,c2,c3,c4,c5,c6]';

[hess,err]=hessian(program1,x0);
[white_SE]=white(program2,x0,hess);   

cell_table2(1:1,2:4)= {'Parameter','Standard_Error','P-value'};
cell_table2(2:18,1:1)= {'sigma_wl','sigma_wh','sigma_xl','sigma_xh',...
                        'R1','R2.3','R4.6','R7.12','R13.+',...
                        'd1','d2','d3','r1','r2','r3',...          
                        'No-obs','Log-Likelihood'};
cell_table2(2:16,2:4)= num2cell(white_SE);
cell_table2(17,2)= {T};
cell_table2(18,2)= {-fval_u2};

% save('../result_files/os_3prm_rec_e24_final.mat')
