% contribution to the distribution of unemployment duration %%

clear all

addpath('../data')
addpath('../result_files')

load tl_3prm_rec_e24_final
sxi_tl = sxi;
BD_tl = BD;
RD_tl = RD;
clearvars -except sxi_tl BD_tl RD_tl

load os_3prm_rec_e24_final
sxi_os = sxi;
BD_os = BD;
RD_os = RD;
clearvars -except sxi_tl BD_tl RD_tl ...
                  sxi_os BD_os RD_os

load qt_3prm_rec_e24_final
sxi_qt = sxi;
BD_qt = BD;
RD_qt = RD;
clearvars -except sxi_tl BD_tl RD_tl ...
                  sxi_os BD_os RD_os ...
                  sxi_qt BD_qt RD_qt

load re_3prm_rec_e24_final
sxi_re = sxi;
BD_re = BD;
RD_re = RD;
clearvars -except sxi_tl BD_tl RD_tl ...
                  sxi_os BD_os RD_os ...
                  sxi_qt BD_qt RD_qt ...
                  sxi_re BD_re RD_re

load ne_3prm_rec_e24_final
sxi_ne = sxi;
BD_ne = BD;
RD_ne = RD;
clearvars -except sxi_tl BD_tl RD_tl ...
                  sxi_os BD_os RD_os ...
                  sxi_qt BD_qt RD_qt ...
                  sxi_re BD_re RD_re ...
                  sxi_ne BD_ne RD_ne U

est_sxi(:,:,1) = sxi_tl;
est_sxi(:,:,2) = sxi_os;
est_sxi(:,:,3) = sxi_qt;
est_sxi(:,:,4) = sxi_re;
est_sxi(:,:,5) = sxi_ne;

est_BD(:,:,1) = BD_tl;
est_BD(:,:,2) = BD_os;
est_BD(:,:,3) = BD_qt;
est_BD(:,:,4) = BD_re;
est_BD(:,:,5) = BD_ne;

est_RD(:,:,1) = RD_tl;
est_RD(:,:,2) = RD_os;
est_RD(:,:,3) = RD_qt;
est_RD(:,:,4) = RD_re;
est_RD(:,:,5) = RD_ne;

T = size(sxi_re,2)
load indfile
IND = ind2(size(U,1)-T+1:size(U,1),1);
load data_dur

%% Average effects of GDD %%

L_tl = mean(sxi_tl(3,:)',1);H_tl = mean(sxi_tl(4,:)',1);
tl_BD_L = exp(-exp(L_tl + BD_tl));tl_RD_L = exp(-exp(L_tl + RD_tl));
tl_BD_H = exp(-exp(H_tl + BD_tl));tl_RD_H = exp(-exp(H_tl + RD_tl));

L_os = mean(sxi_os(3,:)',1);H_os = mean(sxi_os(4,:)',1);
os_BD_L = exp(-exp(L_os + BD_os));os_RD_L = exp(-exp(L_os + RD_os));
os_BD_H = exp(-exp(H_os + BD_os));os_RD_H = exp(-exp(H_os + RD_os));

L_qt = mean(sxi_qt(3,:)',1);H_qt = mean(sxi_qt(4,:)',1);
qt_BD_L = exp(-exp(L_qt + BD_qt));qt_RD_L = exp(-exp(L_qt + RD_qt));
qt_BD_H = exp(-exp(H_qt + BD_qt));t_RD_H = exp(-exp(H_qt + RD_qt));

L_re = mean(sxi_re(3,:)',1);H_re = mean(sxi_re(4,:)',1);
re_BD_L = exp(-exp(L_re + BD_re));re_RD_L = exp(-exp(L_re + RD_re));
re_BD_H = exp(-exp(H_re + BD_re));re_RD_H = exp(-exp(H_re + RD_re));

L_ne = mean(sxi_ne(3,:)',1);H_ne = mean(sxi_ne(4,:)',1);
ne_BD_L = exp(-exp(L_ne + BD_ne));ne_RD_L = exp(-exp(L_ne + RD_ne));
ne_BD_H = exp(-exp(H_ne + BD_ne));ne_RD_H = exp(-exp(H_ne + RD_ne));

hor = 18;

g1 = figure
hold on
set(gca,'fontsize',40)
title('Temporary layoffs')
plot((1:hor),tl_BD_L(1:hor),'-','LineWidth',2,'Color',[0 0 0]) % black
plot((1:hor),tl_RD_L(1:hor),'--','LineWidth',2,'Color',[0 0 0])
%xlabel('Duration of unemployment (months)')
hleg1 = legend('E','R');
set(hleg1,'Location', 'Southeast') 
hold off
saveas(g1,'/figures/TL_GDD','epsc');

g2 = figure
hold on
set(gca,'fontsize',40)
title('Permanent separation')
plot((1:hor),os_BD_L(1:hor),'-','LineWidth',2,'Color',[0 0 0]) % black
plot((1:hor),os_RD_L(1:hor),'--','LineWidth',2,'Color',[0 0 0])
%xlabel('Duration of unemployment (months)')
hleg1 = legend('E','R');
set(hleg1,'Location', 'Southwest') 
hold off
saveas(g2,'/figures/PS_GDD','epsc');

g3 = figure
hold on
set(gca,'fontsize',40)
title('Job leavers')
plot((1:hor),qt_BD_L(1:hor),'-','LineWidth',2,'Color',[0 0 0]) % black
plot((1:hor),qt_RD_L(1:hor),'--','LineWidth',2,'Color',[0 0 0])
%xlabel('Duration of unemployment (months)')
hleg1 = legend('E','R');
set(hleg1,'Location', 'Northeast') 
hold off
saveas(g3,'/figures/JL_GDD','epsc');

g4 = figure
hold on
set(gca,'fontsize',40)
title('Reentrants')
plot((1:hor),re_BD_L(1:hor),'-','LineWidth',2,'Color',[0 0 0]) % black
plot((1:hor),re_RD_L(1:hor),'--','LineWidth',2,'Color',[0 0 0])
%xlabel('Duration of unemployment (months)')
hleg1 = legend('E','R');
set(hleg1,'Location', 'Southwest') 
hold off
saveas(g4,'/figures/RE_GDD','epsc');

g5 = figure
hold on
set(gca,'fontsize',40)
title('New entrants')
plot((1:hor),ne_BD_L(1:hor),'-','LineWidth',2,'Color',[0 0 0]) % black
plot((1:hor),ne_RD_L(1:hor),'--','LineWidth',2,'Color',[0 0 0])
%xlabel('Duration of unemployment (months)')
hleg1 = legend('E','R');
set(hleg1,'Location', 'Southwest') 
hold off
saveas(g5,'/figures/NE_GDD','epsc');

%% type L share calculation

nt=48;

tau = zeros(nt,nt);
 for i=1:nt
 for j=2:nt
     k=i-j+1;
     if k>0
     tau(i,j-1)=k;
     else 
     tau(i,j-1)=0;
     end
 end
 end

 for nn = 1:5
 
sxi = est_sxi(:,:,nn);
BD = est_BD(:,:,nn);
RD = est_RD(:,:,nn);

for t=1:T
    
if IND(t,1)==0;
 D=BD;
else IND(t,1)==1;
 D=RD;
end

 for i=1:nt
 W1(i,t) = sxi(1+4*(i-1),t);
 W2(i,t) = sxi(2+4*(i-1),t);
 X1(i,t) = sxi(3+4*(i-1),t);
 X2(i,t) = sxi(4+4*(i-1),t);
 end

 for i=2:nt
 for j=1:nt            
     if tau(i,j)>0
 MW1(i,j,t) = exp(-exp(X1(j,t)+D(tau(i,j),1)));
 MW2(i,j,t) = exp(-exp(X2(j,t)+D(tau(i,j),1)));
     else
 MW1(i,j,t) = 1;
 MW2(i,j,t) = 1;
 end
 end
 end
 
for j=1:nt
 D_MW1(j,j,t)= prod(MW1(j,:,t),2);
 D_MW2(j,j,t)= prod(MW2(j,:,t),2);
end
 
 D_MW1(1,1,t)= 1;
 D_MW2(1,1,t)= 1;

 UL(1,t)=W1(1,t)*D_MW1(1,1,t);
 UH(1,t)=W2(1,t)*D_MW2(1,1,t);
 TU(1,t)=UL(1,t)+UH(1,t);

for k=2:nt
 UL(k,t)=W1(k,t)*D_MW1(k,k,t);
 UH(k,t)=W2(k,t)*D_MW2(k,k,t);
 TU(k,t)=UL(k,t)+UH(k,t);
end

for kk = 1:nt
est_PL(kk,t,nn) = kk*UL(kk,t);
est_PH(kk,t,nn) = kk*UH(kk,t);
end

end

est_TU(:,:,nn) = TU;
est_UL(:,:,nn) = UL;
est_UH(:,:,nn) = UH;

dur_PL(1,:,nn) = sum(est_PL(:,:,nn),1)./sum(est_UL(:,:,nn),1);
dur_PH(1,:,nn) = sum(est_PH(:,:,nn),1)./sum(est_UH(:,:,nn),1);

 end
 
dur_PL = reshape(dur_PL, T, 5);
dur_PH = reshape(dur_PH, T, 5);

share_L = squeeze(mean(est_UL./est_TU,2));

hor = 18;

g1 = figure
hold on
set(gca,'fontsize',40)
title('Temporary layoffs')
plot((1:hor),share_L(1:hor,1),'-','LineWidth',2,'Color',[0 0 0]) % black
%xlabel('Duration of unemployment (months)')
hold off
saveas(g1,'/figures/TL_share','epsc');

g2 = figure
hold on
set(gca,'fontsize',40)
title('Permanent separation')
plot((1:hor),share_L(1:hor,2),'-','LineWidth',2,'Color',[0 0 0]) % black
%xlabel('Duration of unemployment (months)')
hold off
saveas(g2,'/figures/PS_share','epsc');

g3 = figure
hold on
set(gca,'fontsize',40)
title('Job leavers')
plot((1:hor),share_L(1:hor,3),'-','LineWidth',2,'Color',[0 0 0]) % black
%xlabel('Duration of unemployment (months)')
hold off
saveas(g3,'/figures/JL_share','epsc');

g4 = figure
hold on
set(gca,'fontsize',40)
title('Reentrants')
plot((1:hor),share_L(1:hor,4),'-','LineWidth',2,'Color',[0 0 0]) % black
%xlabel('Duration of unemployment (months)')
hold off
saveas(g4,'/figures/RE_share','epsc');

g5 = figure
hold on
set(gca,'fontsize',40)
title('New entrants')
plot((1:hor),share_L(1:hor,5),'-','LineWidth',2,'Color',[0 0 0]) % black
%xlabel('Duration of unemployment (months)')
hold off
saveas(g5,'/figures/NE_share','epsc');
 