*Set path globals
global path 

global code "$path\Replication Package"
global output "$path\Replication Package"
global figs "$path\Replication Package"
global apisfolder "$path\Data\APIS\" 
global ndhsfolder "$path\Data\DHS\" 
global data "$path\Replication Package"

global boot 0 //set to 1 to run wild cluster bootstrap packages (boottest)
global nvars 2 //for boottest: has to be at least 2

global webb //leave blank for default weights for wild cluster bootstrap code
set scheme lean1

*Data Prep (APIS)
do "$code\data prep apis.do"

*Data Prep (DHS)
do "$code\data prep ndhs.do"

*Table 1: First Stage Estimates
do "$code\paper - first stage pooled.do"

*Table 2: Selection Tests
do "$code\paper - selection.do"

*Table 3: IV Estimates: Effect of Health Insurance on Expenditures (APIS)
*Table 4: IV Estimates: Effect of Health Insurance on Utilization (DHS)
do "$code\paper - iv pooled.do"

*Table 5: Effect of Health Insurance on Chronic and Acute Conditions (DHS)
do "$code\paper - diagnoses.do"

*Figure 2: Insurance Coverage by Age and Year
*Figure 4: Health Expenditures by Age and Year
do "$code\plot - for draft.do"

*Figure 3: 
do "$code\paper - compliers.do"

*Figure 5:
do "$code\paper - MTE.do"
