
*****************************************************************
cap prog drop dominance
prog def dominance, rclass
// This program estimates the upwards and downwards inverse stochastic dominance of the 
// distribution f1 over f2.
// Optionally, it also calculates the variance of the dominance functions at selected 
// points u, and the overall significance level of the dominance relationship.
// The program requires installation of moremata (COMMAND: net describe moremata, from(http://fmwww.bc.edu/RePEc/bocode/m) )
/* It returns in r()
	SCALARS
	- SCALARS: up, down: The degree of dominance
	- SCALARS: error_up, error_down: returned (=1) if the dominance degree >= tolerance
	- SCALARS: min1, min2: The minimum value at which the distributions differ
	- SCALARS: mean1, mean2
	- SCALARS: N1, N2
	- LOCALS: updir, downdir: The name of the variable (f1 or f2) that dominates
	IF SE IS CALLED
	- MATRICES: Lambda_up, Lambda_down : The dominance functions of the differenced 
										 distribution at selected u-s. 
	- MATRICES: varu_up, varu_down
	- SCALARS: var_up, var_down
*/
	syntax varlist(min=2 max=2 numeric) [if] [in] ///
		[, Up Down ///
		f1(varlist max=1 min=1 numeric) /// cdf F(y1)
		f2(varlist max=1 min=1 numeric) /// cdf F(y2) 
		n1(real 0) /// obs in F1
		n2(real 0) /// obs in F2
		TOLerance(real 50) ///
		sort /// Allow collapsing data to distributions (sorting on both f1 and f2)
		gen(string) /// Generate new variable containing dominance functions
		se(string asis) /// requests variance estimation. 
		process ] // requests variance estimation as a process. 
			// Arguments: u(numlist) [ m(real 10000) sims(real 500) seed(real 0) ci(real 5) ]
	marksample touse
	gettoken y1 y2 : varlist
	tempvar diff yy1 yy2 key

	// Default to both
	if "`up'" == "`down'" {
		loc up up
		loc down down
	}

	// Reduce to estimation sample, check sorting
	preserve
	qui keep if `touse'
	sort `y2'
	cap assert `y1'[_n] <= `y1'[_n+1]
	if _rc==9 multisort `y1' `y2', preserve(`f1' `f2')
	if "`f1'" != "" assert `f1'[_n] <= `f1'[_n+1]
	if "`f2'" != "" assert `f2'[_n] <= `f2'[_n+1]
	
	// Preliminary
	forval i=1/2 {
		su `y`i'', meanonly
		ret scalar min`i' = `r(min)'
		ret scalar mean`i' = `r(mean)'
		if `n`i'' == 0 ret scalar N`i' = `r(N)'
		else ret scalar N`i' = `n`i''
		if "`f`i''" == "" { 
			tempvar f`i'	// Gen cdf if not specified
			gen `f`i'' = (_n - 1)/`r(N)' if _n <= `r(N)'
		}
		else return local f`i' ``f''
	}
	cap di 1	// Nulls out _rc
	
	// Check UPWARDS dominance
	* ensure minimum values are different
	loc mm = 2
	loc sign = sign(return(min1) - return(min2))
	while `sign' == 0 {
		loc sign = sign(`y1'[`mm'] - `y2'[`mm'])
		loc ++mm
		if `mm' > _N continue, break
	}
	if `sign' < 0 return local updir `y2'
	else return local updir `y1'
	qui gen double `diff' = `y1' - `y2'
	loc deg = 1
	if `sign' == 0 loc deg `tolerance'
	cap assert (sign(`diff') == `sign' | `diff' == 0 ) 
	qui while _rc==9  & `deg' < `tolerance' {
		myinteg `diff' `f1' , initmin gen(`diff', replace) double 
		loc ++deg
		cap di 1	// Nulls out _rc
		cap assert (sign(`diff') == `sign' | `diff' == 0 ) 
	}
	return scalar up = `deg'
	if `deg' == `tolerance' ret scalar error_up = 1
	if "`process'" != "" {
		qui replace `diff' = abs(`diff')
		su `diff' if `f1' , meanonly
		return scalar mindiff_up = `r(min)'
*		mkmat `f1' if `diff' == `r(min)' | (`diff' <= `r(min)' & `diff'[_n+1] > `r(min)'), mat(xmat)
*		return scalar mindiff_uprank = xmat[1,1]
*		mat drop xmat
	su `diff' if `f1' > .05, meanonly
	return scalar mindiff_up_05 = `r(min)'
		drop `diff'
	}
	if "`gen'" != "" {
		rename `yy1' `gen'1_up
		rename `yy2' `gen'2_up
	}
	
	// Check DOWNWARDS dominance
	qui if `deg' > 2 {
		cap drop `diff'
		qui gen double `diff' = `y1' - `y2' 
		loc mm = 1
		loc sign = sign(return(mean1) - return(mean2))
		while `sign' == 0 {
			su `diff' if _n <= _N - `mm', meanonly
			loc sign = sign(`r(mean)')
			loc ++m
		}
		if `sign' < 0 return local downdir `y2'
		else return local downdir `y1'
		myinteg `diff' `f1', initmin gen(`diff', replace) double
		gen `key' = _n
		loc deg = 2
		if `sign' == 0 loc deg `tolerance'
		cap assert (sign(`diff') == `sign' | `diff' == 0 ) 
		while _rc==9  & `deg' < `tolerance' {
			myinteg `diff' `f1', initmin gen(`diff', replace) down double
			loc ++deg
			cap di 1	// Nulls out _rc
			cap assert (sign(`diff') == `sign' | `diff' == 0 )
		}
		return scalar down = `deg'
		if `deg' == `tolerance' return scalar error_down = 1
		sort `key'
		if "`process'" != "" {
			replace `diff'= abs(`diff') 
			su `diff' , meanonly
			return scalar mindiff_down = `r(min)'
*			mkmat `f1' if `diff' == `r(min)' | (`diff' <= `r(min)' & `diff'[_n+1] > `r(min)'), mat(xmat)
*			return scalar mindiff_downrank = xmat[1,1]
*			mat drop xmat
			drop `diff'
		}
		if "`gen'" != "" {
			rename `yy1' `gen'1_down
			rename `yy2' `gen'2_down
		}
	}
	else {
		return local downdir `return(updir)'
		return scalar down = return(up)
		return scalar mindiff_down = r(mindiff_up)
	}
	
	// Calculate confidence bands (optional)
	qui if "`se'" != "" {
		foreach d in `up' `down' {

*if `return(`d')' > 2 continue

			if "`d'" == "down" & `return(`d')' <= 2 continue
			if `return(`d')' == 1 loc ddeg = 2
			else loc ddeg = return(`d')
			cap mat drop mat1
			cap mat drop diff
			domvar `f1' `y1', p(`ddeg') `se' dir(`d') name(`y1') n(`return(N1)')
			mat rename mat mat1
			domvar `f2' `y2', p(`ddeg') `se' dir(`d') name(`y2') n(`return(N2)')
			mat mat = mat1 , mat
			loc k = rowsof(mat)
			mat diff = mat[1..`k',1]' - mat[1..`k',5]'
			mat se1 = mat[1..`k',2]'
			mat se2 = mat[1..`k',6]'
			mata: st_matrix("vardiff",st_matrix("se1"):^2 + st_matrix("se2"):^2)
			return matrix lambda_`d' = mat			
			domvarcollectmats diff vardiff, name(diff) ci(90)
			return matrix diff_`d' = mat
			mat drop diff vardiff se2 se1 lambda mat1 
			if "`process'" != "" {
				** Get minimum distance if not given
				if `return(`d')' == 1 {
					tempvar diff dd
					gen double `dd' = `y1' - `y2'
					myinteg `dd' `f1', initmin gen(`diff', replace) double ${trapezoid}
					if "`d'" == "down" loc down down
					myinteg `diff' `f1', `down' initmin gen(`diff', replace) double ${trapezoid}
					replace `diff' = abs(`diff')
					** Return minimal distance in return()
					su `diff' , meanonly
					loc mindiff = `r(min)'
					if "`d'" == "up" su `diff' if `f1' > .05, meanonly
					loc mindiff05 = `r(min)'
					drop `diff'
				}
				else {
					loc mindiff = return(mindiff_`d')
					if "`d'" == "up" loc mindiff05 = return(mindiff_`d'_05)
				}
				domvarproc `f1' `y1' `f2' `y2', mindiff(`mindiff') mindiff05(`mindiff05') p(`ddeg') `se' dir(`d') n1(`return(N1)') n2(`return(N2)')
				return add
			}
		}
	}

	
	// Additional returns
	if "`sorted'" != "" restore
	return local cmd dominance
	return local cmdline `return(cmd)' `*'
	
	// Display results
	di 	"=================================================="
	di 	" Upward dominance:  "  return(updir) " of degree " return(up)
	di 	" Downward dominance:  "  return(downdir) " of degree " return(down)
	if max(return(up),return(down)) > `tolerance' di in red ///
		" ** Note: Tolerance level (`tol') reached."
	di 	"=================================================="
	
end
*****************************************************
	// This is an internal program in dominance
	cap prog drop domvarproc
	prog def domvarproc, rclass
	// This program estimates the overall variance of the dominance function viewed as a 
	// process at specified points u. 
		syntax varlist(min=4 max=4 numeric) [if] [in], /// F-1(t) - distribution (levels)
						p(real) /// weighting function - P(t)
						u(numlist >=0 <=1 sort) /// u's at which to simulate
						n1(real) n2(real) ///
					[	ci(real 5) /// Default to 95% confidence interval
						dir(string) /// upwards or downwards inv stoch dominance (default=both)
						name(string) /// prefix added to output in r()
						sims(real 1000) ///
						m(real 1000) ///
						seed(real 0) ///
						mindiff(real -1) /// minimum difference of the dominance function
						mindiff05(real -1) /// minimum difference of the dominance function
						]
		marksample touse
		tempvar f1 f2 ff1 ff2
		foreach uu of numlist `u' {	
			if !inrange(`uu',0,1) error
		}
		if `p'<2 error
		if `p'==2 & "`dir'" == "down" error
		tempfile orig
		qui save `orig', replace
		qui keep if `touse'
		tokenize `varlist'
		loc F1 `1'
		loc y1 `2'
		loc F2 `3'
		loc y2 `4'
		** Get minimum distance if not given
		if `mindiff' < 0 {
			tempvar diff dd
			gen double `dd' = `y1' - `y2'
			myinteg `dd' `f1', initmin gen(`diff', replace) double 
			if "`d'" == "down" loc down down
			myinteg `diff' `f1', `down' initmin gen(`diff', replace) double 
			replace `diff' = abs(`diff')
			** Return minimal distance in return()
			su `diff' , meanonly
			loc mindiff = `r(min)'
			if "`d'" == "up" su `diff' if `f1' > .05, meanonly
			loc mindiff05 = `r(min)'
			drop `diff'
		}
		// Stack distributions to use jointly
		if "`F1'" == "`F2'" {
			loc F2 f2
			qui gen `F2' = `F1'
		}
		qui forval j = 1/2 {
			gen `ff`j'' = (`F`j''[_n] - `F`j''[_n-1]) if _n != 1 
			replace `ff`j'' = `F`j'' if _n == 1 
			replace `ff`j'' = `ff`j''*`n`j''/(`n1' + `n2')
				// Deflate according to population size
		}
		qui stack `ff1' `y1' `ff2' `y2', group(2)
		sort `y1'
		kdensity `y1' , generate(`f1') at(`y1') nograph
		qui gen `F1' = sum(`ff1')
		// Simulate variance
		tempvar x xx
		qui myfaculty `p'-2
		loc i2fac `r(fac)'
		mata: rseed(strtoreal(st_local("seed")))
		mata: Z = rnormal(strtoreal(st_local("m")),strtoreal(st_local("sims")),0,1)
		mata: Tu = J(strtoreal(st_local("m")),strtoreal(st_local("sims")),.)
		local nu : list sizeof u
		mata: T = J(strtoreal(st_local("nu")),strtoreal(st_local("sims")),.)
		mata: s1 = 1
		qui foreach uu of local u {
			forval j = 1/`m' {
				if "`dir'" == "up" {
					gen `x' = (`uu' - `F1')^(`p'-2) * sin(`j' * _pi * `F1') / `f1'
					myinteg `x' `1' if `F1' <= `uu'
					loc hj = `r(integral)' * sqrt(2)/(`i2fac' * `j' * _pi)
				}
				if "`dir'" == "down" {
					gen `x' = (`F1' - `uu')^(`p'-2) * sin(`j' * _pi * `F1') / `f1'
					gen `xx' = (1 - `uu')^(`p'-2) * sin(`j' * _pi * `F1') / `f1' 
					myinteg `x' `F1' if `F1' > `uu'
					loc hj = `r(integral)'
					myinteg `xx' `F1' 
					loc hj = (`r(integral)' - `hj') * sqrt(2)/(`i2fac' * `j' * _pi)
				}
				mata: Tu[.,`j'] = strtoreal(st_local("hj")) * Z[.,`j']
				drop `x'
				cap drop `xx'
			}
			mata: T[s1,.] = colsum(Tu)
			mata: ++s1
		}
		mata: T = sort(colmax(abs(T))',1)
		mata: st_matrix("k",mm_quantile(T,1,(.5, .55, .6, .65, .7, .75, .8, .85, .9, .95, .99)))
				// Requires the package moremata
		mata: st_numscalar("p",sum(T :> strtoreal(st_local("mindiff")))/rows(T))
		mat colnames k = p50 p55 p60 p65 p70 p75 p80 p85 p90 p95 p99
		return matrix k_`dir' = k
		return scalar p_`dir' = p
if "`dir'" == "up" mata: st_numscalar("p",sum(T :> strtoreal(st_local("mindiff05")))/rows(T))
return scalar p_`dir'_05 = p
		use `orig', clear
	end
*****************************************************
	// This is an internal program in dominance
	cap prog drop domvar
	prog def domvar, rclass
	// This program estimates the variance of the dominance function at specified
	// points u. 
	/* It returns:
		- r(varu_up)
		- ... the same for down
		
	*/
		syntax varlist(min=2 max=2 numeric) [if] [in], /// F-1(t) - distribution (levels)
						p(real) /// weighting function - P(t)
						u(numlist >=0 <=1 sort) /// u's at which to simulate
						n(real) ///
					[	ci(real 5) /// Default to 95% confidence interval
						dir(string) /// upwards or downwards inv stoch dominance (default=both)
						name(string) /// prefix added to output in r()
						sims(real 1000) ///
						m(real 1000) ///
						seed(real 0) ///
						]
		marksample touse
		gettoken F y : varlist
		tempvar vuu wl s l 
		foreach uu of numlist `u' {	
			if !inrange(`uu',0,1) error
		}
		if `p'<2 error
		if `p'==2 & "`dir'" == "down" error
		tempfile orig
		qui save `orig', replace
		qui keep if `touse'
		if "`name'" != "" loc name `name'_
		// Combine if join
		domvarlambda_u `F' `y', u(`u') p(`p') dir(`dir')	// sets matrices: lambda_up & lambda_down
		domvarloopoveru `F' `y' , p(`p') u(`u') dir(`dir') n(`n')
			// sets matrix varu_DIR
		domvarcollectmats lambda varu_`dir', ci(90) n(`n') name(`y')
			// sets matrix mat

		qui use `orig', clear
	end
*****************************************************
		// This is an internal program in domvar
		cap prog drop domvarcollectmats
		prog def domvarcollectmats
			syntax anything(name=v) ,  name(string) [ noinvert n(integer 1) ci(cilevel) ] 
			gettoken l v : v
			mat x_se = `v'
			mata: st_matrix("x_se",sqrt(st_matrix("x_se")))
			loc z = invnormal((`ci'/2 + 50)/100)
			tempname cil cih
			mat `cil' = `l' - `z' * x_se
			mat `cih' = `l' + `z' * x_se
			if "`invert'" == "" mat `l' = `l''
			mat mat = `l' , x_se' , `cil'' , `cih''
			mat colnames mat = `name' SE CI`ci'low CI`ci'high
			mat drop x_se
		end
*****************************************************
		// This is an internal program in domvar 
		cap prog drop domvarlambda_u
		prog def domvarlambda_u 
		// This program estimates the dominance functions, and returns the matrices 
		// lambda_up and lambda_down of dimension 1 X length(u)
			syntax varlist(min=2 max=2 numeric), p(real) u(numlist) dir(string)
			gettoken F y : varlist
			qui myfaculty `p'-2
			loc i2fac `r(fac)'
			cap mat drop lambda
			tempvar l
			qui foreach uu in `u' {
				if "`dir'" == "up" {
					gen double 	`l' = (`uu' - `F')^(`p'-2) *`y' if `F' <= `uu'
					myinteg `l' `F' if `F' <= `uu', ${trapezoid}
					matrix lambda = nullmat(lambda) ///
										, (1/`i2fac') * `r(integral)'
				}
				else if "`dir'" == "down" {
					myinteg `y' `F' , ${trapezoid}
					loc meany `r(integral)'
					gen double 	`l' = (`F'-`uu')^(`p'-2) * `y' if `F' > `uu'
					myinteg `l' `F' if `F' > `uu' , 
					matrix lambda = nullmat(lambda) ///
										, (1/`i2fac') * (1-`uu')^(`p'-2)*`meany' - `r(integral)'
				}
				drop `l'
				loc c : subinstr local uu "." ""
				loc lc : length local c
				if `lc' == 1 loc c `c'0
				loc cols `cols' p`c'
			}
			mat colnames lambda = `cols'
		end
	*****************************************************
			cap prog drop domvarloopoveru
			prog def domvarloopoveru
			// This is an internal program in domvar
			// This program sets matrix varu with dimension 1 X length(u)
			// Variable list should contain a cdf and its inverse (in that order)
			// u should be a list of population shares
				syntax varlist(max=2 min=2) , u(numlist) p(real) DIRection(string) n(real)
				gettoken F y : varlist
				if `p' < 2 error	
				if "`direction'" == "up" loc v v2uv
				if "`direction'" == "down" loc v eta2uv	
				cap matrix drop varu_`direction'
				loc j = 1
				qui foreach uu in `u' {
					`v' `F' `y' , u(`uu') v(`uu') p(`p')
					matrix varu_`direction' = nullmat(varu_`direction') , `v'/`n'
					loc unames `unames' u`j'
					loc ++j
				}
				matrix colnames varu_`direction' = `unames'	
				sca drop `v'
			end
	*****************************************************
				cap prog drop v2uv
				prog def v2uv
				// This is an internal program in domvarloopoveru
				// This program sets scalar v2uv 
				// Variable list should contain a cdf and its inverse (in that order)
				// DATA MUST BE SORTED. NO SUBSAMPLING ALLOWED.
				// u and v should be lists of population shares, where u :<= v (element by element)
				// Though v is allowed to be different from u, this part of the program is not tested
					syntax varlist(max=2 min=2) , u(real) v(real) p(real)
					gettoken F F1 : varlist
					if `p' < 2 error
					if `v' < `u' {
						loc vv `u'	// order so that u < v
						loc u `v'
						loc v `vv'
					}
				
					qui foreach uu in u v {
						count if `F' <= ``uu''
						loc n`uu' = `r(N)'
						if `n`uu'' == 0 loc n`uu' = 1 // Alternatively error 
					}
					tempvar x intx y1 y2
					qui gen `x' = (`u' - `F')^(`p'-2) * `F' if `F' < `u'
					qui myinteg `x' `F1' if `F' < `u', gen(`intx') ${trapezoid}
					qui gen `y1' = (`v' - `F')^(`p'-2) * (1 - `F') * `intx'
					qui myinteg `y1' `F1' if _n < `nu' ,  ${trapezoid}
					loc inty0u = `r(integral)'	
					qui if `u' != `v' {
						gen `y2' = (`v' - `F')^(`p'-2) * (1 - `F') * `intx'[`nu']
						myinteg `y2' `F1' if inrange(`F',`u',`v'), ${trapezoid}
						loc intyuv = `r(integral)'
					}
					else loc intyuv = 0
					
					qui myfaculty `p'-2
					sca def v2uv = (1/`r(fac)'^2) * (2*`inty0u' + `intyuv')/(sqrt(_N))
				end
				*****************************************************
				cap prog drop eta2uv
				prog def eta2uv , rclass
				// This is an internal program in domvarloopoveru
				// This program sets scalar eta2uv 
				// Variable list should contain a cdf and its inverse (in that order)
				// DATA MUST BE SORTED. NO SUBSAMPLING ALLOWED.
				// u and v should be lists of population shares, where u :<= v (element by element)
				// Though v is allowed to be different from u, this part of the program is not tested
					syntax varlist(max=2 min=2) , u(real) v(real) p(real)
					gettoken F F1 : varlist
					if `p' < 2 error
					if `v' < `u' {
						loc vv `u'	// order so that u < v
						loc u `v'
						loc v `vv'
					}
				
					lambda `F' `F1' , p(`p') u(0) v(0) s(0) k(2) r(2)			name(22000)
					lambda `F' `F1' , p(`p') u(`u') v(`v') s(`v') k(2) r(`p')	name(2puvv)
					lambda `F' `F1' , p(`p') u(`u') v(`v') s(`v') k(`p') r(2)	name(p2uvv)
					gamma `F' `F1' , p(`p') u(0) v(`v') k(2) r(`p')				name(2p0v)
					if `u'== `v' {
						sca def l2puuu = l2puvv
						sca def lp2uuu = lp2uvv
						sca def g2p0u = g2p0v
					}
					else {
						lambda `F' `F1' , p(`p') u(`u') v(`u') s(`u') k(2) r(`p')	name(2puuu)
						lambda `F' `F1' , p(`p') u(`u') v(`u') s(`u') k(`p') r(2)	name(p2uuu)
						gamma `F' `F1' , p(`p') u(0) v(`u') k(2) r(`p') 			name(2p0u)
					}	
					lambda `F' `F1' , p(`p') u(`u') v(`v') s(`v') k(`p') r(`p')	name(ppuvv)
					lambda `F' `F1' , p(`p') u(`v') v(`u') s(`v') k(`p') r(`p')	name(ppvuv)
					gamma `F' `F1' , p(`p') u(`u') v(`v') k(`p') r(`p')			name(ppuv)
				
					sca def eta2uv = (2*((1-`u')*(1-`v'))^(`p'-2) * l22000 ///
								- (1-`u')^(`p'-2) * (l2puvv + lp2uvv + g2p0v) ///
								- (1-`v')^(`p'-2) * (l2puuu + lp2uuu + g2p0u) ///
								+ lppuvv + lppvuv + gppuv ) /(sqrt(_N))
					di "eta2(u,v) = " eta2uv
				end
*****************************************************
					cap prog drop lambda
					prog def lambda
					// This is an internal program in eta2uv
						syntax varlist(max=2 min=2) , p(real) u(real) v(real) s(real) k(real) r(real) [ name(string) ]
						gettoken F F1 : varlist
						tempvar x int y
						qui gen `x' = (`F' - `u')^(`k'-2) * `F' if `F' >= `s'
						qui myinteg `x' `F1' if `F' >= `s', gen(`int') ${trapezoid}
						qui gen `y' = (`F' - `v')^(`r'-2) * (1 - `F') * `int'
						qui myinteg `y' `F1' if `F' >= `s', ${trapezoid}
						loc l = `r(integral)'
						qui myfaculty `p'-2
						scalar def l`name' = (1/`r(fac)'^2) * `l'
						
						noi di "l`name' = " l`name' 
					end
*****************************************************
					cap prog drop gamma
					prog def gamma
					// This is an internal program in eta2uv
						syntax varlist(max=2 min=2) , p(real) u(real) v(real) k(real) r(real) [ name(string) ]
						gettoken F F1 : varlist
					
						if `u' == `v' scalar def g`name' = 0
						else {
							tempvar x int y
							qui gen `x' = (`F' - `u')^(`k'-2) * `F' if inrange(`F',`u',`v')
							qui myinteg `x' `F1' if inrange(`F',`u',`v'), ${trapezoid}
							qui gen `y' = (`F' - `v')^(`r'-2) * (1 - `F') * `r(integral)'
							qui myinteg `y' `F1' if inrange(`F',`v',1), ${trapezoid}
							loc l = `r(integral)'
							qui myfaculty `p'-2
							scalar def g`name' = (1/`r(fac)'^2)*`l'
						}	
					
						noi di "g`name' = " g`name' 
					end

*****************************************************
** NO LONGER USED
*****************************************************
		// This is an internal program in domvar
		cap prog drop domvarsim
		prog def domvarsim
		// This program estimates the variance at fixed u, returned in matrices: v2uu, eta2uu
		// both of dimension 1 X length(u)
		// It also estimates the overall variance of the dominance function, which is returned
			syntax varlist(min=2 max=2 numeric), p(real) u(numlist) DIRection(string) n(real) ///
												[ process sims(real 1000) m(real 1000) seed(real 0)]
			gettoken F y : varlist
			if `seed' != 0 set seed `seed'
			domvarloopoveru `F' `y' , p(`p') u(`u') dir(`direction') n(`n')
			if "`process'" == "" {
				if "`direction'" == "down" mata: v = sqrt(st_matrix("varu_down"))
				if "`direction'" == "up" mata: v = sqrt(st_matrix("varu_up"))
				mata: Z = rnormal(strtoreal(st_local("m")),strtoreal(st_local("sims")),0,1)
				mata: T = abs(colsum(v # Z))
				mata: T = colmax(rowshape(T,cols(v)))
				mata: k = mm_quantile(sort(T',1),1,(.001, .01, .05, .1, .9, .95, .99, .999))
						// Requires the package moremata
				mata: st_matrix("k",k)
				mat colnames k = p001 p01 p05 p10 p90 p95 p99 p999
				mat k_`direction' = k
				mat drop k
			}
		end
*****************************************************

*******************************************************************************
* Example
*******************************************************************************

/*
sysuse auto, clear
su price
gen x = price - 10 if _n<=60
replace x = price +10 if _n>60
replace x = price + 20 if _n <5
su x

set more off
multisort price x

gen f = (_n-1)/_N
eta2uv f price, u(0.9) v(0.9) p(4)
sca list
stopher

dominance price x, se(u(.1(.1).9) seed(2207793) sims(100))
	// se-options: u(numlist) [ m(real 10000) sims(real 500) seed(real 0) ci(real 5) ]

stopher

*/
// Calculate dominance for UK
cd "C:\Users\slacouture\Dropbox\UChicago RA\Magne\Various\ECER-NET"
u data/eudist_hinc, clear
keep *UK*
qui foreach var of varlist * {
	replace `var' = 0 if `var' < 0
	}
	
loc i = 1 
gettoken t1min : tlist
set more off
set trace off
set tracedepth 3
keep if mod(_n,10) == 0
gen yyear = 1993 + _n if 1993 + _n <= 2001
replace yyear = 1996 + _n if inrange(1993 + _n,2002,2007)
gen f = _n/(_N+1)


set more off

gen m = 1000*_n if _n <= 100
loc j = 1
forval m = 1000(1000)1000 {
set tr off
	dominance hincUK2010 hincUK2009, n1(4000) n2(4000) f1(f) f2(f) ///
		se(u(.1(.1).9) m(500) sims(`m') seed(2)) process 
	foreach mat in k_up k_down {
		mat mat = r(`mat')
		foreach p in 50 55 60 65 70 75 80 85 90 95 99 {
			if `m'==1000 gen `mat'`p' = .
			mat x = mat[1,"p`p'"]
			sca xx = x[1,1]
			replace `mat'`p' = xx if m == `m'
		}
	}
}
mat list r(k_up)
mat list r(k_down)
mat list r(lambda_up)
mat list r(diff_up)
mat list r(lambda_down)
mat list r(diff_down)

ret list
stop

cap prog drop mygenmissing 
mygenmissing kdown kup
gen m = _n*1000 if _n <= 100
qui forval i = 1000(1000)100000 {
	simdots `i' 10000
	dominance hincUK2009 hincUK2010, f1(f) f2(f) se(u(.1(.1).9) m(`i') seed(1))
	replace kdown = r(k_down) if m == `i'
	replace kup = r(k_up) if m == `i'
}
two line kup m, name(up)
two line kdown m, name(down)
 
*/


qui forval t1= 1994/2010 {
	cap confirm var hincUK`t1'
	if _rc continue
	loc i = `i' + 1 	
	forval t2= 1994/2010 {
		cap confirm var hincUK`t2'
		if _rc continue
		cap gen UKupdown`t2' = ""
		if `t2' <= `t1' continue
		dominance hincUK`t1' hincUK`t2', f1(f) f2(f) tol(100)
		noi di "`t1' vs `t2': down = `r(down)'; up = `r(up)'; f1min=`r(min1)', f2min=`r(min2)'
		foreach r in down up {
			cap gen UK`r'`t2' = ""
			if "`r(`r'dir)'" == "hincUK`t1'" loc dir >
			if "`r(`r'dir)'" == "hincUK`t2'" loc dir <
			if "`r(`r')'" != "" {
				replace UK`r'`t2' = "`r(`r')'`dir'" if yyear == `t1'
				if "`r'"=="up" replace UKupdown`t2' = "`r(`r')'`dir'" if yyear == `t1'
				else replace UKupdown`t1' = "`r(`r')'`dir'" if yyear == `t2'
			}
			if "`r'"=="up" & r(up) <= 2 replace UKdown`t2' = "`r(up)'`dir'" if yyear == `t1'
			if inlist("`r'","meandiff","mindiff","mean","gini","sd","p10","p20","p80","p90") replace UK`r'`t2' = "``r''" if yyear == `t1'
			cap gen t`t2'_2nd = ""
			cap gen t`t2'_3rd_up = ""
			cap gen t`t2'_3rd_down = ""
			if "`r'"=="up" & r(`r') <= 2 replace t`t2'_2nd = "`dir'" if yyear == `t1'
			if r(`r') <= 3 | r(up) <= 2 replace t`t2'_3rd_`r' = "`dir'" if yyear == `t1'
		}
		foreach r in updir downdir {
			cap gen UK`r'`t2' = ""
			if "`r(`r')'" != "" replace UK`r'`t2' = "`r(`r')'" if yyear == `t1'
		}
	}
}

stop

br yyear UKup1* UKup2* if yyear != .
br yyear UKdown1* UKdown2* if yyear != .
br yyear t????_2nd if yyear != .
br yyear t????_3rd_up if yyear != .
br yyear t????_3rd_down if yyear != .
br yyear *updown* if yyear != .
br yyear p????_3rd_up if yyear != .
br yyear p????_3rd_down if yyear != .

*/
*/

// 2009 vs 2010 with variance
cd "C:\Users\slacouture\Dropbox\UChicago RA\Magne\Various\ECER-NET"
u data/eudist_hinc, clear
loc vars hincUK2009 hincUK2010
keep `vars'
gen f = _n/(_N+1)
qui foreach var of varlist * {
	replace `var' = 0 if `var' < 0
	}
dominance `vars', f1(f) f2(f)
