clearvars
close all
figpath = '.\paper\figs\';

date_string = '20210618';
% country = 'Germany';
country = 'UK';
tmax = datetime(2020,06,28); 

N = 50000;
nsimul = 1000;
roll_window = 14;
gamma = 1/14;
MF = 5;
path_write = [pwd,'/results_empirical/',date_string,'_counterfactual_roll',...
    num2str(roll_window/7),'W_MF',num2str(MF),'/'];

colormap = get(groot,'defaultAxesColorOrder');
if strcmp(country,'Germany')
    mycolor = [colormap(1,:); colormap(2,:)];
    lstring = 'later';
else
    mycolor = [colormap(1,:); colormap(3,:)];
    lstring = 'earlier';
end

%% load results
fname_write = [path_write, country,'_ER_shift0W_N',num2str(N),...
    '_nsimul',num2str(nsimul)];
results_0W = load(fname_write);

fname_write = [path_write, country,'_ER_shift1W_N',num2str(N),...
    '_nsimul',num2str(nsimul)];
results_1W = load(fname_write);

fname_write = [path_write, country,'_ER_shift2W_N',num2str(N),...
    '_nsimul',num2str(nsimul)];
results_2W = load(fname_write);

ReT_0W = ((1-mean(results_0W.results_sim.cT)).*results_0W.parm.betaT'./gamma)';
ReT_1W = ((1-mean(results_1W.results_sim.cT)).*results_1W.parm.betaT'./gamma)';
ReT_2W = ((1-mean(results_2W.results_sim.cT)).*results_2W.parm.betaT'./gamma)';

Tplot = length(ReT_0W);
tmin = tmax - Tplot + 1;

%% summarize results
[tab_0W_mean, tab_0W_med] = fn_summary_onegroup(results_0W.results_sim.cT, results_0W.results_sim.iT, Tplot);
[tab_1W_mean, tab_1W_med] = fn_summary_onegroup(results_1W.results_sim.cT, results_1W.results_sim.iT, Tplot);
[tab_2W_mean, tab_2W_med] = fn_summary_onegroup(results_2W.results_sim.cT, results_2W.results_sim.iT, Tplot);
table_mean = [tab_0W_mean; tab_1W_mean; tab_2W_mean];
table_mean = table_mean(:,1:3);
table_med = [tab_0W_med; tab_1W_med; tab_2W_med];
table_med = table_med(:,1:3);
fprintf('  ------Mean------ \n');
fprintf('  cmax   imax  imax_t \n');
fprintf('%6.2f    %2.2f   %2.0f\n', table_mean')
fprintf('  ------Median------ \n');
fprintf('  cmax   imax  imax_t \n');
fprintf('%6.2f    %2.2f   %2.0f\n', table_med')

%% plot Re 1week
h_1W = figure(1);
plot(tmin:tmax,ReT_0W,'-','Linewidth',2,'Color', mycolor(1,:))
hold on
plot(tmin:tmax,ReT_1W,'--','Linewidth',2.5,'Color', mycolor(2,:))
hold on;
plot(tmin:tmax,ones(1,Tplot),'--','Color',ones(1,3)*150/255,'Linewidth',1.5) 
hold off
pbaspect([5 4 1])
box('off')
ylabel('${\hat{\mathcal{R}}_{et}}$','Interpreter','Latex','Color','black')
hl = legend('Calibrated social distancing',...
    ['Social distancing 1 week ',lstring]);
legend('Location','NorthEast')
legend boxoff 
set(hl,'Fontsize',12)
ax = gca;
ax.LineWidth = 1.2;
ax.FontSize = 12;
ax.TickDir = 'out';
xlim([tmin,tmax])
xticks(tmin:7:tmax)
xtickformat('MMM dd')
xtickangle(90)
ylim([0,3])


%% plot Re 2week
Tplot = length(ReT_0W);
tmin = tmax - Tplot + 1;

h_2W = figure(2);
plot(tmin:tmax,ReT_0W,'-','Linewidth',2,'Color', mycolor(1,:))
hold on
plot(tmin:tmax,ReT_2W,'--','Linewidth',2.5,'Color', mycolor(2,:))
hold on;
plot(tmin:tmax,ones(1,Tplot),'--','Color',ones(1,3)*150/255,'Linewidth',1.5) 
hold off
pbaspect([5 4 1])
box('off')
ylabel('${\hat{\mathcal{R}}_{et}}$','Interpreter','Latex','Color','black')
hl = legend('Calibrated social distancing',...
    ['Social distancing 2 weeks ',lstring]);
legend('Location','NorthEast')
legend boxoff 
set(hl,'Fontsize',12)
ax = gca;
ax.LineWidth = 1.2;
ax.FontSize = 12;
ax.TickDir = 'out';
xlim([tmin,tmax])
xticks(tmin:7:tmax)
xtickformat('MMM dd')
xtickangle(90)
ylim([0,3])

%% save figures
figname_1W = [country,'_ER_shift1W_Re'];
figname_2W = [country,'_ER_shift2W_Re'];

saveas(h_1W,[figpath, figname_1W,'.png'])
saveas(h_2W,[figpath, figname_2W,'.png'])

%% save csv files
fname_0W = [path_write,country,'_ER_shift0W'];
fname_1W = [path_write,country,'_ER_shift1W'];
fname_2W = [path_write,country,'_ER_shift2W'];

dlmwrite([fname_0W,'_cT.csv'],results_0W.results_sim.cT*100, 'precision','%4.16f')
dlmwrite([fname_0W,'_iT.csv'],results_0W.results_sim.iT*100, 'precision','%4.16f')
dlmwrite([fname_1W,'_cT.csv'],results_1W.results_sim.cT*100, 'precision','%4.16f')
dlmwrite([fname_1W,'_iT.csv'],results_1W.results_sim.iT*100, 'precision','%4.16f')
dlmwrite([fname_2W,'_cT.csv'],results_2W.results_sim.cT*100, 'precision','%4.16f')
dlmwrite([fname_2W,'_iT.csv'],results_2W.results_sim.iT*100, 'precision','%4.16f')

