clearvars
close all;
date_string = '20210618';
figpath = '.\paper\figs\';

country_list = {'Austria','France','Germany','Italy','Spain','UK'};

N = 50000;
nsimul = 500;
ini_days = 7;
MA_window = 7;
gamma = 1/14;
network_string = 'ER';
MF_ini = 5;  % initial value

for ci = 1:length(country_list)
    close all
    country = char(country_list(ci));
    path_write_2W = ['.\results_empirical\',date_string,'_MF2W_guess',num2str(MF_ini),'_N',num2str(N),'_par\'];
    results_2W = load([path_write_2W,country,'_ER_results']);
    path_write_3W = ['.\results_empirical\',date_string,'_MF3W_guess',num2str(MF_ini),'_N',num2str(N),'_par\'];
    results_3W = load([path_write_3W,country,'_ER_results']);
    
    %% plot Re
    tmax = min(results_2W.tmax, results_3W.tmax);
    if results_2W.tmin_TR~=results_3W.tmin_TR
        error("check tmin!")  % written for the equal case
    end
    tmin = results_2W.tmin_TR;
    Tplot = length(results_3W.Re);  
    
    h_Re = figure(1);
    plot(tmin:tmax,results_2W.Re(1:Tplot),'Linewidth',2);
    hold on;
    plot(tmin:tmax,results_3W.Re,'Linewidth',2,'Linestyle','--');
    hold on;
    plot(tmin:tmax,ones(1,Tplot),'--','Color',ones(1,3)*150/255,'Linewidth',1.5) 
    ylabel('${\hat{\mathcal{R}}_{et}}$','Interpreter','Latex','Color','black')
    legend('2-weekly rolling estimates','3-weekly rolling estimates')
    legend boxoff
    box('off')
    ax = gca;
    ax.LineWidth = 1.2;
    ax.FontSize = 12;
    ax.TickDir = 'out';
    xlim([tmin,tmax])
    xticks(tmin:21:tmax)
    xtickformat('MMM dd')
    xtickangle(90)
    ylim([0,3])    
    
    %% plot MF      
    colormap = get(groot,'defaultAxesColorOrder');
    h_MF = figure(2);
    tmin = results_2W.date_est_set(1);
    tmax = results_3W.date_est_set(end);
    line(results_2W.date_est_set,results_2W.MF_pt, 'Linewidth',2)
    hold on
    scatter(results_2W.date_est_set,results_2W.MF_pt,'filled','o')
    hold on
    line(results_3W.date_est_set,results_3W.MF_pt, 'Linewidth',2,'Linestyle','--','Color',colormap(2,:))
    hold on
    scatter(results_3W.date_est_set,results_3W.MF_pt,'filled','o')    
    hold off
    legend('2-weekly rolling estimates','','3-weekly rolling estimates')
    legend boxoff
    box('off')
    ax = gca;
    ax.LineWidth = 1.2;
    ax.FontSize = 12;
    ax.TickDir = 'out';
    xlim([tmin,tmax])
    xticks(tmin:14:tmax)
    xtickformat('MMM dd')
    xtickangle(90)
    if strcmp(country,'France')
        ylim([1,12])
    elseif strcmp(country, 'UK')
        ylim([1,11])
    else        
        ylim([1,10])
    end
    
    %% save figures
    figname_Re = [country,'_ER_N',num2str(N),'_guess',num2str(MF_ini),...
        '_cmp_window_Re'];
    figname_MF = [country,'_ER_N',num2str(N),'_guess',num2str(MF_ini),...
        '_cmp_window_MF'];
    
    saveas(h_Re,[figpath, figname_Re,'.png'])
    saveas(h_MF,[figpath, figname_MF,'.png'])

end




